/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.security.Key;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import javax.crypto.SecretKey;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.signature.SignatureMethodDSA;
import weblogic.xml.security.signature.SignatureMethodFactory;
import weblogic.xml.security.signature.SignatureMethodHMAC;
import weblogic.xml.security.signature.SignatureMethodRSA;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class SignatureMethod
implements DSIGConstants {
    public static final String DSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String RSA_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String HMAC_SHA1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();

    private static final void initFactories() {
        SignatureMethodRSA.init();
        SignatureMethodDSA.init();
        SignatureMethodHMAC.init();
    }

    public abstract String getURI();

    public String toString() {
        return "SignatureMethod:  algorithmURI = " + this.getURI();
    }

    static SignatureMethod get(Key key) throws XMLSignatureException {
        if (key instanceof DSAKey) {
            return SignatureMethod.get(DSA_SHA1);
        }
        if (key instanceof RSAKey) {
            return SignatureMethod.get(RSA_SHA1);
        }
        if (key instanceof SecretKey) {
            return SignatureMethod.get(HMAC_SHA1);
        }
        throw new XMLSignatureException("cannot find algorithm for key");
    }

    public static void register(SignatureMethodFactory signatureMethodFactory) {
        factories.put((Object)signatureMethodFactory.getURI(), (Object)signatureMethodFactory);
    }

    public static SignatureMethod get(String string) throws XMLSignatureException {
        SignatureMethodFactory signatureMethodFactory = (SignatureMethodFactory)factories.get((Object)string);
        if (signatureMethodFactory == null) {
            throw new XMLSignatureException(string + " not supported");
        }
        return signatureMethodFactory.newSignatureMethod();
    }

    protected abstract boolean verify(Key var1, byte[] var2, String var3) throws XMLSignatureException;

    protected abstract String sign(Key var1, byte[] var2) throws XMLSignatureException;

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute("Algorithm", this.getURI())};
        StreamUtils.addElement(xMLOutputStream, string, "SignatureMethod", null, attributeArray, n, 2);
    }

    static SignatureMethod fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        SignatureMethod signatureMethod = null;
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "SignatureMethod");
        if (startElement != null) {
            String string2 = StreamUtils.getAttribute(startElement, "Algorithm");
            StreamUtils.requiredAttr(string2, "SignatureMethod", "Algorithm");
            signatureMethod = SignatureMethod.get(string2);
            signatureMethod.fromXMLInternal(xMLInputStream, string);
            StreamUtils.closeScope(xMLInputStream, string, "SignatureMethod");
        }
        return signatureMethod;
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#rsa-sha1\"/>\n");
        SignatureMethod signatureMethod = (SignatureMethod)DSIGReader.read(xMLInputStream, 9);
        System.out.println(signatureMethod);
        System.out.println("Implemented by: " + signatureMethod.getClass().getName());
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        signatureMethod.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }

    static {
        SignatureMethod.initFactories();
    }
}

