/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.SignatureMethod;
import weblogic.xml.security.signature.SignatureMethodFactory;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class SignatureMethodHMAC
extends SignatureMethod
implements SignatureMethodFactory,
DSIGConstants {
    public static final String URI_SHA1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private static final String ALGORITHM_ID_SHA1 = "HmacSHA1";
    private final String uri;
    private final String algorithmID;
    private final Mac algorithm;
    private int outputLength = 160;

    public SignatureMethodHMAC(String string, String string2) throws NoSuchAlgorithmException {
        this.uri = string;
        this.algorithmID = string2;
        this.algorithm = Mac.getInstance(ALGORITHM_ID_SHA1);
    }

    public String getURI() {
        return this.uri;
    }

    static void init() {
        try {
            SignatureMethod.register(new SignatureMethodHMAC(URI_SHA1, ALGORITHM_ID_SHA1));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public SignatureMethod newSignatureMethod() {
        try {
            return new SignatureMethodHMAC(this.uri, this.algorithmID);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public String sign(Key key, byte[] byArray) throws XMLSignatureException {
        try {
            this.algorithm.init(key);
            this.algorithm.update(byArray);
            byte[] byArray2 = new byte[this.outputLength / 8];
            byte[] byArray3 = this.algorithm.doFinal();
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
            return Utils.base64(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("Invalid key", invalidKeyException);
        }
    }

    protected boolean verify(Key key, byte[] byArray, String string) throws XMLSignatureException {
        try {
            this.algorithm.init(key);
            this.algorithm.update(byArray);
            byte[] byArray2 = this.algorithm.doFinal();
            byte[] byArray3 = Utils.base64(string);
            int n = this.outputLength / 8;
            for (int i = 0; i < n; ++i) {
                if (byArray2[i] == byArray3[i]) continue;
                return false;
            }
            return true;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("Invalid key", invalidKeyException);
        }
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        String string2 = StreamUtils.getValue(xMLInputStream, string, "HMACOutputLength");
        if (string2 == null) {
            return;
        }
        try {
            this.outputLength = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLStreamException("Invalid HMACOutputLength: " + string2);
        }
    }
}

