/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.SignatureMethod;
import weblogic.xml.security.signature.SignatureMethodFactory;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.utils.Utils;

class SignatureMethodRSA
extends SignatureMethod
implements SignatureMethodFactory,
DSIGConstants {
    public static final String URI_SHA1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private static final String ALGORITHM_ID_SHA1 = "SHA1withRSA";
    private final String uri;
    private final String algorithmID;
    private final Signature algorithm;

    private SignatureMethodRSA(String string, String string2) throws NoSuchAlgorithmException {
        this.uri = string;
        this.algorithmID = string2;
        this.algorithm = Signature.getInstance(ALGORITHM_ID_SHA1);
    }

    public String getURI() {
        return this.uri;
    }

    static void init() {
        try {
            SignatureMethod.register(new SignatureMethodRSA(URI_SHA1, ALGORITHM_ID_SHA1));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public SignatureMethod newSignatureMethod() {
        try {
            return new SignatureMethodRSA(this.uri, this.algorithmID);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    protected String sign(Key key, byte[] byArray) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            throw new XMLSignatureException(this.getURI() + " signing requires private key");
        }
        try {
            this.algorithm.initSign((PrivateKey)key);
            this.algorithm.update(byArray);
            byte[] byArray2 = this.algorithm.sign();
            return Utils.base64(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    protected boolean verify(Key key, byte[] byArray, String string) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            throw new XMLSignatureException(this.getURI() + " verification requires public key");
        }
        try {
            this.algorithm.initVerify((PublicKey)key);
            this.algorithm.update(byArray);
            byte[] byArray2 = Utils.base64(string);
            return this.algorithm.verify(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }
}

