/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.io.OutputStream;
import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import weblogic.utils.Debug;
import weblogic.utils.io.UnsyncByteArrayOutputStream;
import weblogic.xml.security.signature.CanonicalizationMethod;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.signature.InvalidReferenceException;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.ReferenceValidationException;
import weblogic.xml.security.signature.SignatureGenerationException;
import weblogic.xml.security.signature.SignatureMethod;
import weblogic.xml.security.signature.SignatureValidationException;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

class SignedInfo
implements DSIGConstants {
    private CanonicalizationMethod c14nMethod;
    private SignatureMethod signatureMethod;
    private final Map references = new HashMap();
    private boolean signatureValidated = false;
    private XMLInputStream signedInfoStream;
    private Map namespaces = new HashMap();
    private int indent;

    SignedInfo() {
        try {
            this.c14nMethod = CanonicalizationMethod.get("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new AssertionError((Object)xMLSignatureException);
        }
    }

    SignedInfo(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    void addReference(Reference reference) {
        Reference reference2 = (Reference)this.references.get(reference.getURI());
        if (reference2 != null) {
            reference.copyDigestValue(reference2);
        }
        this.references.put(reference.getURI(), reference);
    }

    Iterator getReferences() {
        return this.references.values().iterator();
    }

    void setCanonicalizationMethod(String string) throws XMLSignatureException {
        this.setCanonicalizationMethod(CanonicalizationMethod.get(string));
    }

    void setCanonicalizationMethod(CanonicalizationMethod canonicalizationMethod) {
        this.c14nMethod = canonicalizationMethod;
    }

    void setSignatureMethod(SignatureMethod signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    String getSignatureMethodURI() {
        if (this.signatureMethod == null) {
            return null;
        }
        return this.signatureMethod.getURI();
    }

    private void digest() throws SignatureGenerationException {
        Iterator iterator = this.getReferences();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            try {
                reference.digest();
            }
            catch (InvalidReferenceException invalidReferenceException) {
                throw new SignatureGenerationException((Throwable)((Object)invalidReferenceException));
            }
        }
    }

    String sign(Key key) throws XMLSignatureException {
        if (this.signatureMethod == null) {
            this.signatureMethod = SignatureMethod.get(key);
        }
        this.digest();
        return this.signatureMethod.sign(key, this.c14n());
    }

    private byte[] c14n() throws SignatureGenerationException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        XMLOutputStream xMLOutputStream = this.c14nMethod.canonicalize((OutputStream)unsyncByteArrayOutputStream, this.namespaces);
        NamespaceAwareXOS namespaceAwareXOS = new NamespaceAwareXOS(xMLOutputStream);
        namespaceAwareXOS.addPrefix("http://www.w3.org/2000/09/xmldsig#", "dsig");
        try {
            this.toXML(namespaceAwareXOS, "http://www.w3.org/2000/09/xmldsig#", -this.indent);
            xMLOutputStream.close(true);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SignatureGenerationException("canonicalization error", xMLStreamException);
        }
        byte[] byArray = unsyncByteArrayOutputStream.toByteArray();
        if (VERBOSE) {
            System.out.println("<!-- -- Begin c14ned SignedInfo - Sign ----->");
            System.out.println(new String(byArray));
            System.out.println("<!-----  End c14ned SignedInfo - Sign  -- -->");
        }
        return byArray;
    }

    private byte[] c14n(XMLInputStream xMLInputStream) throws SignatureValidationException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        XMLOutputStream xMLOutputStream = this.c14nMethod.canonicalize((OutputStream)unsyncByteArrayOutputStream, this.namespaces);
        try {
            xMLOutputStream.add(xMLInputStream);
            xMLOutputStream.close(true);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SignatureValidationException("canonicalization error", xMLStreamException);
        }
        byte[] byArray = unsyncByteArrayOutputStream.toByteArray();
        if (VERBOSE) {
            System.out.println("<!-- -- Begin c14ned SignedInfo - Verify ----->");
            System.out.println(new String(byArray));
            System.out.println("<!-----  End c14ned SignedInfo - Verify  -- -->");
        }
        return byArray;
    }

    void validate(Key key, String string) throws XMLSignatureException {
        if (!this.signatureValidated) {
            this.validateSignature(key, string);
        }
        this.validateReferences();
    }

    void validateSignature(Key key, String string) throws XMLSignatureException {
        byte[] byArray = this.c14n(this.signedInfoStream);
        if (!this.signatureMethod.verify(key, byArray, string)) {
            throw new SignatureValidationException("signature failed to verify");
        }
        this.signatureValidated = true;
    }

    void validateReferences() throws XMLSignatureException {
        Object object;
        if (!this.signatureValidated) {
            throw new SignatureValidationException("Must validate signature before validating references.");
        }
        LinkedList<InvalidReferenceException> linkedList = null;
        Iterator iterator = this.getReferences();
        while (iterator.hasNext()) {
            object = (Reference)iterator.next();
            try {
                if (VERBOSE) {
                    Debug.say((String)(" +++ validating reference : " + object));
                }
                ((Reference)object).validate();
                if (!VERBOSE) continue;
                Debug.say((String)(" +++ validated reference : " + object));
            }
            catch (InvalidReferenceException invalidReferenceException) {
                if (VERBOSE) {
                    invalidReferenceException.printStackTrace();
                }
                if (linkedList == null) {
                    linkedList = new LinkedList<InvalidReferenceException>();
                }
                linkedList.add(invalidReferenceException);
            }
        }
        if (linkedList != null) {
            object = "One or more references failed to validate";
            InvalidReferenceException[] invalidReferenceExceptionArray = new InvalidReferenceException[linkedList.size()];
            invalidReferenceExceptionArray = linkedList.toArray(invalidReferenceExceptionArray);
            throw new ReferenceValidationException((String)object, invalidReferenceExceptionArray);
        }
    }

    void setIndent(int n) {
        this.indent = n;
    }

    void setNamespaces(Map map) {
        this.namespaces.clear();
        this.namespaces.putAll(map);
        if (VERBOSE) {
            Debug.say((String)(" +++ Setting namespaces (" + map + ")"));
        }
    }

    void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        if (n < 0) {
            n = -n;
            StreamUtils.addStart(xMLOutputStream, string, "SignedInfo");
        } else {
            StreamUtils.addStart(xMLOutputStream, string, "SignedInfo", n);
        }
        if (this.c14nMethod != null) {
            this.c14nMethod.toXML(xMLOutputStream, string, n + 2);
        }
        if (this.signatureMethod != null) {
            this.signatureMethod.toXML(xMLOutputStream, string, n + 2);
        }
        Iterator iterator = this.getReferences();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            reference.toXML(xMLOutputStream, string, n + 2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "SignedInfo", n);
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.signedInfoStream = xMLInputStream.getSubStream();
        StartElement startElement = (StartElement)xMLInputStream.next();
        this.setNamespaces(startElement.getNamespaceMap());
        this.c14nMethod = (CanonicalizationMethod)DSIGReader.read(xMLInputStream, 1);
        this.signatureMethod = (SignatureMethod)DSIGReader.read(xMLInputStream, 9);
        Reference reference = (Reference)DSIGReader.read(xMLInputStream, 6);
        while (reference != null) {
            this.references.put(reference.getURI(), reference);
            reference = (Reference)DSIGReader.read(xMLInputStream, 6);
        }
        StreamUtils.closeScope(xMLInputStream, string, "SignedInfo");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n  <CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments\"></CanonicalizationMethod>\n  <SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#dsa-sha1\"></SignatureMethod>\n  <Reference URI=\"file:///d|/weblogic/dev/sandbox/billjg/dsig/alpha.txt\">\n    <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></DigestMethod>\n    <DigestValue>gCVvOanTCGUKyQ2b6acqlWJFRXQ=</DigestValue>\n  </Reference>\n</SignedInfo>\n");
        SignedInfo signedInfo = (SignedInfo)DSIGReader.read(xMLInputStream, 10);
        System.out.println(signedInfo);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        signedInfo.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }
}

