/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.util.Iterator;
import java.util.Map;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.InternalReference;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.transforms.ExcC14NTransform;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.Observer;
import weblogic.xml.security.utils.XMLStreamObserver;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SoapSignXMLOutputStream
extends XMLOutputStreamBase
implements DSIGConstants,
NSOutputStream {
    private NSOutputStream dest;
    private XMLEvent lastSpace;
    private XMLStreamObserver unresolvedReferences = new XMLStreamObserver(WSSEConstants.ID_NAMESPACES);

    public SoapSignXMLOutputStream(XMLOutputStream xMLOutputStream) {
        this.dest = !(xMLOutputStream instanceof NSOutputStream) ? new NamespaceAwareXOS(xMLOutputStream) : (NSOutputStream)xMLOutputStream;
        this.addPrefix("http://www.w3.org/2000/09/xmldsig#", "dsig");
    }

    public void addSignature(Signature signature) throws XMLStreamException {
        this.setupSignature(signature);
    }

    protected void setupSignature(Signature signature) {
        Iterator iterator = signature.getReferences();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            this.addReference(reference);
        }
    }

    public void addReference(Reference reference) {
        if (reference instanceof InternalReference) {
            InternalReference internalReference = (InternalReference)reference;
            String string = reference.getURI();
            this.unresolvedReferences.add(string, (Observer)internalReference);
            if (WSSEConstants.C14N_INCLUSIVE_NAMESPACES) {
                ExcC14NTransform.setupSign(this.unresolvedReferences, string, internalReference);
            }
        }
    }

    public void addObserver(String string, Observer observer) {
        this.unresolvedReferences.add(string, observer);
    }

    protected void addXMLEvent(XMLEvent xMLEvent) throws XMLStreamException {
        if (xMLEvent == null) {
            return;
        }
        if (!this.unresolvedReferences.observe(xMLEvent)) {
            this.dest.add(xMLEvent);
        }
    }

    public void flush() throws XMLStreamException {
        this.dest.flush();
    }

    public void close() throws XMLStreamException {
        this.flush();
        this.dest.close();
    }

    public void close(boolean bl) throws XMLStreamException {
        if (bl) {
            this.flush();
        }
        this.dest.close(bl);
    }

    public void addPrefix(String string, String string2) {
        this.dest.addPrefix(string, string2);
    }

    public Map getNamespaces() {
        return this.dest.getNamespaces();
    }
}

