/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.xml.security.keyinfo.KeyResolver;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.InternalReference;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.transforms.ExcC14NTransform;
import weblogic.xml.security.utils.Observer;
import weblogic.xml.security.utils.XMLInputStreamBase;
import weblogic.xml.security.utils.XMLStreamObserver;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class SoapVerifyXMLInputStream
extends XMLInputStreamBase
implements DSIGConstants {
    private final List signatures = new ArrayList(1);
    private KeyResolver resolver;
    private XMLStreamObserver unresolvedReferences = new XMLStreamObserver(WSSEConstants.ID_NAMESPACES);

    private SoapVerifyXMLInputStream(XMLInputStream xMLInputStream, KeyResolver keyResolver) {
        super(xMLInputStream);
        this.resolver = keyResolver != null ? keyResolver : new KeyResolver();
    }

    public SoapVerifyXMLInputStream(Signature signature, XMLInputStream xMLInputStream) throws XMLStreamException {
        this(signature, xMLInputStream, null);
    }

    public SoapVerifyXMLInputStream(Signature signature, XMLInputStream xMLInputStream, KeyResolver keyResolver) throws XMLSignatureException {
        this(xMLInputStream, keyResolver);
        this.addSignature(signature);
    }

    public SoapVerifyXMLInputStream(Signature[] signatureArray, XMLInputStream xMLInputStream, KeyResolver keyResolver) throws XMLStreamException {
        this(xMLInputStream, keyResolver);
        for (int i = 0; i < signatureArray.length; ++i) {
            Signature signature = signatureArray[i];
            this.addSignature(signature);
        }
    }

    public SoapVerifyXMLInputStream(Signature[] signatureArray, XMLInputStream xMLInputStream) throws XMLStreamException {
        this(signatureArray, xMLInputStream, null);
    }

    public void addSignature(Signature signature) throws XMLSignatureException {
        if (this.resolver == null) {
            throw new IllegalStateException("No KeyResolver: cannot resolve key to validate signature");
        }
        signature.validateSignature(this.resolver);
        this.setupSignature(signature);
    }

    private void setupSignature(Signature signature) {
        this.signatures.add(signature);
        Iterator iterator = signature.getReferences();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (!(reference instanceof InternalReference)) continue;
            InternalReference internalReference = (InternalReference)reference;
            String string = internalReference.getURI();
            this.unresolvedReferences.add(string, (Observer)internalReference);
            if (!WSSEConstants.C14N_INCLUSIVE_NAMESPACES) continue;
            ExcC14NTransform.setupVerify(this.unresolvedReferences, string, internalReference);
        }
    }

    public XMLEvent next() throws XMLStreamException {
        XMLEvent xMLEvent = this.source.next();
        this.unresolvedReferences.observe(xMLEvent);
        return xMLEvent;
    }
}

