/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.signature;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import weblogic.xml.security.transforms.NodeTransform;
import weblogic.xml.security.transforms.OctetTransform;
import weblogic.xml.security.transforms.Transform;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLOutputStream;

public class TransformUtils {
    private static final XMLInputStreamFactory inFactory = XMLInputStreamFactory.newInstance();

    public static void process(InputStream is, Transform t) throws IOException {
        if (t instanceof OctetTransform) {
            TransformUtils.process(is, (OctetTransform)t);
        } else if (t instanceof NodeTransform) {
            TransformUtils.process(is, (NodeTransform)t);
        } else {
            throw new AssertionError((Object)("Unknown Transform type : " + t.getClass()));
        }
    }

    public static void process(InputStream is, OctetTransform t) throws IOException {
        byte[] buf = new byte[4096];
        OutputStream os2 = t.getOutputStream();
        int nread = 0;
        while ((nread = is.read(buf, 0, buf.length)) != -1) {
            os2.write(buf, 0, nread);
        }
    }

    public static void process(InputStream is, NodeTransform t) throws IOException {
        XMLInputStream xmlIn = inFactory.newInputStream(is);
        XMLOutputStream xmlOut = t.getXMLOutputStream();
        while (xmlIn.hasNext()) {
            xmlOut.add(xmlIn.next());
        }
        xmlOut.close();
    }
}

