/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import java.util.ArrayList;
import weblogic.xml.security.specs.SpecBase;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class BinarySecurityTokenSpec
extends SpecBase {
    private String valueType = null;
    private String encoding = null;
    public static final BinarySecurityTokenSpec DEFAULT_SPEC = new BinarySecurityTokenSpec();

    public BinarySecurityTokenSpec() {
        this(WSSEConstants.VALUETYPE_X509V3, WSSEConstants.ENCODING_BASE64);
    }

    public BinarySecurityTokenSpec(String string, String string2) {
        if (!WSSEConstants.VALUETYPE_X509V3.equals(string)) {
            throw new AssertionError((Object)("Unsupported valueType: " + string));
        }
        if (!WSSEConstants.ENCODING_BASE64.equals(string2)) {
            throw new AssertionError((Object)("Unsupported encoding: " + string2));
        }
        this.valueType = string;
        this.encoding = string2;
    }

    public BinarySecurityTokenSpec(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getValueType() {
        return this.valueType;
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "BinarySecurityTokenSpec");
        if (startElement == null) {
            throw new XMLStreamException("Expected BinarySecurityTokenSpec, got " + startElement);
        }
        this.encoding = StreamUtils.getAttribute(startElement, "EncodingType");
        StreamUtils.requiredAttr(this.encoding, "BinarySecurityTokenSpec", "EncodingType");
        this.valueType = StreamUtils.getAttribute(startElement, "ValueType");
        StreamUtils.requiredAttr(this.valueType, "BinarySecurityTokenSpec", "ValueType");
        if (!WSSEConstants.ENCODING_BASE64.equals(this.encoding)) {
            throw new AssertionError((Object)("Unsupported encoding \"" + this.encoding + "\""));
        }
        if (!WSSEConstants.VALUETYPE_X509V3.equals(this.valueType)) {
            throw new AssertionError((Object)"Unsupported value type");
        }
        StreamUtils.closeScope(xMLInputStream, string, "BinarySecurityTokenSpec");
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray;
        ArrayList arrayList = new ArrayList(2);
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(2);
        if (xMLOutputStream instanceof NSOutputStream) {
            attributeArray = (Attribute[])xMLOutputStream;
        } else {
            attributeArray = new NamespaceAwareXOS(xMLOutputStream);
            xMLOutputStream = attributeArray;
            attributeArray.addPrefix("http://www.openuri.org/2002/11/wsse/spec", "spec");
            attributeArray.addPrefix(WSSEConstants.WSSE_URI, "wsse");
        }
        if (this.valueType != null) {
            arrayList2.add(StreamUtils.createAttribute("ValueType", this.valueType));
        }
        if (this.encoding != null) {
            arrayList2.add(StreamUtils.createAttribute("EncodingType", this.encoding));
        }
        attributeArray = new Attribute[arrayList2.size()];
        arrayList2.toArray(attributeArray);
        Attribute[] attributeArray2 = new Attribute[arrayList.size()];
        arrayList.toArray(attributeArray2);
        StreamUtils.addStart(xMLOutputStream, string, "BinarySecurityTokenSpec", attributeArray, attributeArray2, n);
        StreamUtils.addEnd(xMLOutputStream, string, "BinarySecurityTokenSpec", n);
    }

    public static BinarySecurityTokenSpec getDefaultSpec() {
        return DEFAULT_SPEC;
    }

    public String toString() {
        return "weblogic.xml.security.specs.BinarySecurityTokenSpec{valueType=" + this.valueType + ", encoding=" + this.encoding + "}";
    }
}

