/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import weblogic.xml.security.specs.SpecBase;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class ElementIdentifier
extends SpecBase {
    private String localPart = null;
    private String namespace = null;
    private String restriction = null;
    private XMLName name = null;

    public ElementIdentifier(String string, String string2) {
        this(string, string2, null);
    }

    public ElementIdentifier(QName qName, String string) {
        this(qName.getNamespaceURI(), qName.getLocalPart(), string);
    }

    public ElementIdentifier(QName qName) {
        this(qName, null);
    }

    public ElementIdentifier(String string, String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (!ElementIdentifier.validRestriction(string3)) {
            throw new IllegalArgumentException("Unsupported restriction: " + string3);
        }
        this.localPart = string2;
        this.namespace = string;
        this.restriction = string3;
    }

    public ElementIdentifier(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public XMLName getXMLName() {
        if (this.name == null) {
            this.name = ElementFactory.createXMLName(this.namespace, this.localPart);
        }
        return this.name;
    }

    public String getRestriction() {
        return this.restriction;
    }

    public String getLocalName() {
        return this.localPart;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(3);
        if (this.localPart != null) {
            arrayList.add(ElementFactory.createAttribute(string, "LocalPart", this.localPart));
        }
        if (this.namespace != null) {
            arrayList.add(ElementFactory.createAttribute(string, "Namespace", this.namespace));
        }
        if (this.restriction != null) {
            arrayList.add(ElementFactory.createAttribute(string, "Restriction", this.restriction));
        }
        Attribute[] attributeArray = new Attribute[arrayList.size()];
        arrayList.toArray(attributeArray);
        StreamUtils.addStart(xMLOutputStream, string, "ElementIdentifier", attributeArray, n);
        StreamUtils.addEnd(xMLOutputStream, string, "ElementIdentifier", n);
    }

    public static final boolean validRestriction(String string) {
        return string == null || "body".equals(string) || "header".equals(string);
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "ElementIdentifier");
        if (startElement == null) {
            throw new XMLStreamException("Expected ElementIdentifier, got " + startElement);
        }
        this.localPart = StreamUtils.getAttribute(startElement, "LocalPart");
        StreamUtils.requiredAttr(this.localPart, "ElementIdentifier", "LocalPart");
        this.namespace = StreamUtils.getAttribute(startElement, "Namespace");
        this.restriction = StreamUtils.getAttribute(startElement, "Restriction");
        StreamUtils.closeScope(xMLInputStream, string, "ElementIdentifier");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ElementIdentifier)) {
            return false;
        }
        ElementIdentifier elementIdentifier = (ElementIdentifier)object;
        if (this.localPart != null ? !this.localPart.equals(elementIdentifier.localPart) : elementIdentifier.localPart != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(elementIdentifier.namespace) : elementIdentifier.namespace != null) {
            return false;
        }
        return !(this.restriction != null ? !this.restriction.equals(elementIdentifier.restriction) : elementIdentifier.restriction != null);
    }

    public int hashCode() {
        int n = this.localPart != null ? this.localPart.hashCode() : 0;
        n = 29 * n + (this.namespace != null ? this.namespace.hashCode() : 0);
        n = 29 * n + (this.restriction != null ? this.restriction.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "ElementIdentifier type=" + this.localPart + " namespace=" + this.namespace + " restriction=" + this.restriction;
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<ElementIdentifier xmlns=\"http://www.openuri.org/2002/11/wsse/spec\"\n      LocalPart=\"fooBarBaz\"\n      Restriction=\"body\"\n      Namespace=\"wsse:Base64Binary\" />");
        ElementIdentifier elementIdentifier = new ElementIdentifier(xMLInputStream, "http://www.openuri.org/2002/11/wsse/spec");
        System.out.println(elementIdentifier);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        elementIdentifier.toXML(xMLOutputStream);
        xMLOutputStream.flush();
    }
}

