/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import java.security.cert.X509Certificate;
import weblogic.xml.security.specs.ElementIdentifier;
import weblogic.xml.security.specs.OperationSpec;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.wsse.BinarySecurityToken;
import weblogic.xml.security.wsse.Token;
import weblogic.xml.security.wsse.v200207.BinarySecurityTokenImpl;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class EncryptionSpec
extends OperationSpec {
    private String encryptionMethod = null;
    private String keyWrappingMethod = null;
    private X509Certificate cert = null;
    private BinarySecurityToken bst = null;
    private static final String DEFAULT_ENCRYPTION_METHOD = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    private static final String DEFAULT_KEYWRAPPING_METHOD = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    private static final EncryptionSpec DEFAULT_SPEC = new EncryptionSpec("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", null, true);

    public EncryptionSpec(String string, X509Certificate x509Certificate) {
        this(string, DEFAULT_KEYWRAPPING_METHOD, x509Certificate, false);
    }

    public EncryptionSpec(String string, X509Certificate x509Certificate, boolean bl) {
        this(string, DEFAULT_KEYWRAPPING_METHOD, x509Certificate, bl);
    }

    public EncryptionSpec(String string, String string2, X509Certificate x509Certificate, boolean bl) {
        this.encryptionMethod = string;
        this.setKeyWrappingMethod(string2);
        this.setCertificate(x509Certificate);
        this.setEntireBody(bl);
    }

    public EncryptionSpec(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
        this.bst = x509Certificate != null ? new BinarySecurityTokenImpl(x509Certificate, null) : null;
    }

    public Token getToken() {
        return this.bst;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Object object;
        if (!(xMLOutputStream instanceof NSOutputStream)) {
            object = null;
            object = new NamespaceAwareXOS(xMLOutputStream);
            xMLOutputStream = object;
            object.addPrefix("http://www.openuri.org/2002/11/wsse/spec", "spec");
        }
        object = new Attribute[]{ElementFactory.createAttribute(string, "EncryptionMethod", this.encryptionMethod), ElementFactory.createAttribute(string, "KeyWrappingMethod", this.getKeyWrappingMethod()), ElementFactory.createAttribute(string, "EncryptBody", this.entireBody() ? "true" : "false")};
        StreamUtils.addStart(xMLOutputStream, string, "EncryptionSpec", (Attribute[])object, n);
        int n2 = n + 2;
        if (this.bst != null) {
            this.bst.toXML(xMLOutputStream);
        }
        for (ElementIdentifier elementIdentifier : this.headerList) {
            elementIdentifier.toXML(xMLOutputStream, string, n2);
        }
        for (ElementIdentifier elementIdentifier : this.bodyList) {
            elementIdentifier.toXML(xMLOutputStream, string, n2);
        }
        for (ElementIdentifier elementIdentifier : this.unrestrictedList) {
            elementIdentifier.toXML(xMLOutputStream, string, n2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "EncryptionSpec", n);
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "EncryptionSpec");
        if (startElement == null) {
            throw new XMLStreamException("Expected EncryptionSpec, got " + startElement);
        }
        this.encryptionMethod = StreamUtils.getAttribute(startElement, "EncryptionMethod");
        StreamUtils.requiredAttr(this.encryptionMethod, "EncryptionSpec", "EncryptionMethod");
        this.keyWrappingMethod = StreamUtils.getAttribute(startElement, "KeyWrappingMethod");
        this.setEntireBody("true".equals(StreamUtils.getAttribute(startElement, "EncryptBody")));
        XMLEvent xMLEvent = StreamUtils.peekElement(xMLInputStream);
        if (xMLEvent.isStartElement() && StreamUtils.matches(xMLEvent, "BinarySecurityToken", WSSEConstants.WSSE_URI)) {
            this.bst = new BinarySecurityTokenImpl(xMLInputStream, WSSEConstants.WSSE_URI);
            this.cert = this.bst.getCertificate();
            xMLEvent = StreamUtils.peekElement(xMLInputStream);
        }
        while (!xMLEvent.isEndElement()) {
            if (xMLEvent.isStartElement() && StreamUtils.matches(xMLEvent, "ElementIdentifier", string)) {
                ElementIdentifier elementIdentifier = new ElementIdentifier(xMLInputStream, string);
                String string2 = elementIdentifier.getRestriction();
                if (string2 == null) {
                    this.addUnrestrictedType(elementIdentifier);
                } else if ("body".equals(string2)) {
                    this.addBodyElement(elementIdentifier);
                } else {
                    this.addHeaderElement(elementIdentifier);
                }
            } else {
                StreamUtils.discard(xMLInputStream);
            }
            xMLEvent = StreamUtils.peekElement(xMLInputStream);
        }
        StreamUtils.closeScope(xMLInputStream, string, "EncryptionSpec");
    }

    public static EncryptionSpec getDefaultSpec() {
        return DEFAULT_SPEC;
    }

    public String toString() {
        return "weblogic.xml.security.specs.EncryptionSpec{encryptionMethod='" + this.encryptionMethod + "'" + ", cert=" + this.cert + ", bst=" + this.bst + "}";
    }

    public String getKeyWrappingMethod() {
        return this.keyWrappingMethod == null ? DEFAULT_KEYWRAPPING_METHOD : this.keyWrappingMethod;
    }

    public void setKeyWrappingMethod(String string) {
        if (string != null && !"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(string) && !DEFAULT_KEYWRAPPING_METHOD.equals(string)) {
            throw new IllegalArgumentException(string + " is not a supported key wrapping" + " algorithm");
        }
        this.keyWrappingMethod = string;
    }
}

