/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import weblogic.xml.security.specs.SpecConstants;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class EntityDescriptor
implements SpecConstants {
    private String name = null;
    private String password = null;

    public EntityDescriptor(String string, String string2) {
        this.name = string;
        this.password = string2;
    }

    public EntityDescriptor(XMLInputStream xMLInputStream) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public abstract String elementTagName();

    public void fromXMLInternal(XMLInputStream xMLInputStream) throws XMLStreamException {
        XMLEvent xMLEvent = StreamUtils.skipWS(xMLInputStream, false);
        StartElement startElement = null;
        XMLName xMLName = null;
        if (!xMLEvent.isStartElement()) {
            throw new XMLStreamException("Did not receive expected element " + this.elementTagName());
        }
        startElement = (StartElement)xMLEvent;
        xMLName = startElement.getName();
        if (!xMLName.getLocalName().equals(this.elementTagName())) {
            throw new XMLStreamException("Did not receive expected element " + this.elementTagName());
        }
        xMLEvent = this.skipToElement(xMLInputStream);
        if (!xMLEvent.isStartElement()) {
            throw new XMLStreamException(this.elementTagName() + " did not include a " + "name" + " or " + "password");
        }
        startElement = (StartElement)xMLEvent;
        String string = startElement.getName().getLocalName();
        if (!"name".equals(string)) {
            throw new XMLStreamException("In " + this.elementTagName() + ", got " + string + " expected " + "name");
        }
        this.name = EntityDescriptor.getValue(xMLInputStream, "name");
        xMLEvent = this.skipToElement(xMLInputStream);
        if (!xMLEvent.isStartElement()) {
            throw new XMLStreamException(this.elementTagName() + " did not include a " + "password");
        }
        startElement = (StartElement)xMLEvent;
        string = startElement.getName().getLocalName();
        if (!"password".equals(string)) {
            throw new XMLStreamException("In " + this.elementTagName() + ", got " + string + " expected " + "password");
        }
        this.password = EntityDescriptor.getValue(xMLInputStream, "password");
        StreamUtils.closeScope(xMLInputStream, this.elementTagName());
    }

    private XMLEvent skipToElement(XMLInputStream xMLInputStream) throws XMLStreamException {
        XMLEvent xMLEvent = StreamUtils.skipWS(xMLInputStream, true);
        while (!xMLEvent.isEndElement() && !xMLEvent.isStartElement()) {
            xMLInputStream.next();
            xMLEvent = StreamUtils.skipWS(xMLInputStream, true);
        }
        return xMLEvent;
    }

    public void toXML(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, this.elementTagName());
        if (this.name != null) {
            StreamUtils.addElement(xMLOutputStream, "name", this.name, 0);
        }
        if (this.password != null) {
            StreamUtils.addElement(xMLOutputStream, "password", this.password, 0);
        }
        StreamUtils.addEnd(xMLOutputStream, this.elementTagName());
    }

    public static String getValue(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        XMLEvent xMLEvent = EntityDescriptor.getElementByTagName(xMLInputStream, string);
        if (xMLEvent == null) {
            return null;
        }
        xMLEvent = StreamUtils.skipWS(xMLInputStream, false);
        if (!xMLEvent.isCharacterData()) {
            throw new XMLStreamException(string + " does not contain text: " + xMLEvent);
        }
        String string2 = ((CharacterData)xMLEvent).getContent();
        xMLEvent = StreamUtils.skipWS(xMLInputStream, false);
        if (!xMLEvent.isEndElement()) {
            throw new XMLStreamException("Malformed " + string);
        }
        return string2.trim();
    }

    private static XMLEvent getElementByTagName(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        XMLEvent xMLEvent = StreamUtils.skipWS(xMLInputStream, true);
        if (!xMLEvent.isStartElement() || !xMLEvent.getName().getLocalName().equals(string)) {
            return null;
        }
        return xMLInputStream.next();
    }
}

