/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.xml.security.specs.ElementIdentifier;
import weblogic.xml.security.specs.SpecBase;
import weblogic.xml.stream.XMLName;

public abstract class OperationSpec
extends SpecBase {
    protected ArrayList unrestrictedList = new ArrayList();
    private ElementIdentifier[] unrestricted = null;
    protected ArrayList bodyList = new ArrayList();
    private ElementIdentifier[] body = null;
    protected ArrayList headerList = new ArrayList();
    private ElementIdentifier[] header = null;
    private boolean entireBody = false;

    public boolean entireBody() {
        return this.entireBody;
    }

    public XMLName[] getHeaderElementNames() {
        return OperationSpec.getTypeNames(this.headerList);
    }

    public final ElementIdentifier[] getHeaderElementSpecs() {
        if (this.header == null) {
            this.header = OperationSpec.listToArray(this.headerList);
        }
        return this.header;
    }

    public final ElementIdentifier[] getBodyElementSpecs() {
        if (this.body == null) {
            this.body = OperationSpec.listToArray(this.bodyList);
        }
        return this.body;
    }

    public final ElementIdentifier[] getUnrestrictedElementSpecs() {
        if (this.unrestricted == null) {
            this.unrestricted = OperationSpec.listToArray(this.unrestrictedList);
        }
        return this.unrestricted;
    }

    private static ElementIdentifier[] listToArray(ArrayList arrayList) {
        ElementIdentifier[] elementIdentifierArray = new ElementIdentifier[arrayList.size()];
        elementIdentifierArray = arrayList.toArray(elementIdentifierArray);
        return elementIdentifierArray;
    }

    public XMLName[] getBodyElementNames() {
        return OperationSpec.getTypeNames(this.bodyList);
    }

    public XMLName[] getUnrestrictedElementNames() {
        return OperationSpec.getTypeNames(this.unrestrictedList);
    }

    private static final XMLName[] getTypeNames(List list) {
        XMLName[] xMLNameArray = new XMLName[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            xMLNameArray[n] = ((ElementIdentifier)iterator.next()).getXMLName();
            ++n;
        }
        return xMLNameArray;
    }

    public void addElement(QName qName, String string) {
        this.addElement(qName.getNamespaceURI(), qName.getLocalPart(), string);
    }

    public boolean contains(String string, String string2, String string3) {
        ElementIdentifier elementIdentifier = new ElementIdentifier(string, string2, string3);
        boolean bl = string3 == null ? this.unrestrictedList.contains(elementIdentifier) : ("body".equals(string3) ? this.bodyList.contains(elementIdentifier) : ("header".equals(string3) ? this.headerList.contains(elementIdentifier) : false));
        return bl;
    }

    public void addElement(String string, String string2, String string3) {
        if (!ElementIdentifier.validRestriction(string3)) {
            throw new IllegalArgumentException("Illegal restriction type: " + string3);
        }
        ElementIdentifier elementIdentifier = new ElementIdentifier(string, string2, string3);
        if (string3 == null) {
            this.addUnrestrictedType(elementIdentifier);
        } else if ("body".equals(string3)) {
            this.addBodyElement(elementIdentifier);
        } else if ("header".equals(string3)) {
            this.addHeaderElement(elementIdentifier);
        } else {
            throw new AssertionError((Object)("Unsupported restriction:" + string3));
        }
    }

    protected void addHeaderElement(ElementIdentifier elementIdentifier) {
        this.headerList.add(elementIdentifier);
        this.header = null;
    }

    protected void setEntireBody(boolean bl) {
        this.entireBody = bl;
    }

    protected void addBodyElement(ElementIdentifier elementIdentifier) {
        this.bodyList.add(elementIdentifier);
        this.body = null;
    }

    protected void addUnrestrictedType(ElementIdentifier elementIdentifier) {
        this.unrestrictedList.add(elementIdentifier);
        this.unrestricted = null;
    }
}

