/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.xml.security.specs.BinarySecurityTokenSpec;
import weblogic.xml.security.specs.EncryptionKey;
import weblogic.xml.security.specs.EncryptionSpec;
import weblogic.xml.security.specs.SecuritySpec;
import weblogic.xml.security.specs.SignatureKey;
import weblogic.xml.security.specs.SignatureSpec;
import weblogic.xml.security.specs.SpecConstants;
import weblogic.xml.security.specs.TimestampConfig;
import weblogic.xml.security.specs.User;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SecurityDD
implements SpecConstants {
    private SignatureKey signingKey = null;
    private EncryptionKey encryptionKey = null;
    private User user = null;
    private final Map specs = new HashMap();
    private TimestampConfig timestampConfig = null;
    private static final SecurityDD DEFAULT_DD = SecurityDD.createDefaultSecurityDD();

    public SecurityDD(XMLInputStream xMLInputStream) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream);
        if (this.timestampConfig == null) {
            this.timestampConfig = new TimestampConfig();
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public SecurityDD(SecuritySpec securitySpec) {
        String string = securitySpec.getId();
        if (string == null) {
            string = "default-spec";
            securitySpec.setId(string);
        }
        this.addSecuritySpec(securitySpec);
    }

    public void addSecuritySpec(SecuritySpec securitySpec) {
        SecuritySpec securitySpec2;
        String string = securitySpec.getId();
        if (string == null) {
            string = "default-spec";
            securitySpec.setId(string);
        }
        if ((securitySpec2 = (SecuritySpec)this.specs.get(string)) != null) {
            throw new IllegalArgumentException("SecuritySpec with id=" + string + " already exists in the DD");
        }
        this.specs.put(string, securitySpec);
    }

    public SecuritySpec removeSecuritySpec(String string) {
        return (SecuritySpec)this.specs.remove(string);
    }

    public SecuritySpec getSecuritySpec(String string) {
        if (string == null) {
            string = "default-spec";
        }
        return (SecuritySpec)this.specs.get(string);
    }

    public Iterator getSecuritySpecs() {
        return this.specs.values().iterator();
    }

    public SecuritySpec getSpec() {
        return this.getSecuritySpec("default-spec");
    }

    public void setSpec(SecuritySpec securitySpec) {
        this.addSecuritySpec(securitySpec);
    }

    public SecuritySpec getSecuritySpec() {
        return this.getSecuritySpec("default-spec");
    }

    public SignatureKey getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(SignatureKey signatureKey) {
        this.signingKey = signatureKey;
    }

    public EncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(EncryptionKey encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public TimestampConfig getTimestampConfig() {
        return this.timestampConfig;
    }

    public void setTimestampConfig(TimestampConfig timestampConfig) {
        this.timestampConfig = timestampConfig;
    }

    private static SecurityDD createDefaultSecurityDD() {
        SecuritySpec securitySpec = new SecuritySpec();
        securitySpec.setBinarySecurityTokenSpec(BinarySecurityTokenSpec.getDefaultSpec());
        securitySpec.setEncryptionSpec(EncryptionSpec.getDefaultSpec());
        securitySpec.setSignatureSpec(SignatureSpec.getDefaultSpec());
        SecurityDD securityDD = new SecurityDD(securitySpec);
        return securityDD;
    }

    public static final SecurityDD getDefaultSecurityDD() {
        return DEFAULT_DD;
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream) throws XMLStreamException {
        XMLEvent xMLEvent = StreamUtils.skipWS(xMLInputStream, false);
        if (!xMLEvent.isStartElement()) {
            throw new XMLStreamException("Did not receive expected start Element security");
        }
        StartElement startElement = (StartElement)xMLEvent;
        XMLName xMLName = startElement.getName();
        if (!"security".equals(xMLName.getLocalName())) {
            throw new XMLStreamException("Did not receive expected start Element security");
        }
        xMLEvent = StreamUtils.skipWS(xMLInputStream, true);
        while (!xMLEvent.isEndElement()) {
            if (!xMLEvent.isStartElement()) {
                xMLInputStream.next();
            } else {
                startElement = (StartElement)xMLEvent;
                xMLName = startElement.getName();
                if (xMLName.getLocalName().equals("user")) {
                    if (this.user != null) {
                        throw new XMLStreamException("Received multiple users in dd, only one is allowed");
                    }
                    this.user = new User(xMLInputStream);
                } else if (xMLName.getLocalName().equals("encryptionKey")) {
                    if (this.encryptionKey != null) {
                        throw new XMLStreamException("Received multiple encryption keys in dd, only one is allowed");
                    }
                    this.encryptionKey = new EncryptionKey(xMLInputStream);
                } else if (xMLName.getLocalName().equals("timestamp")) {
                    if (this.timestampConfig != null) {
                        throw new XMLStreamException("Received multiple timestamp configurations in dd, only one is allowed");
                    }
                    this.timestampConfig = new TimestampConfig(xMLInputStream);
                } else if (xMLName.getLocalName().equals("signatureKey")) {
                    if (this.signingKey != null) {
                        throw new XMLStreamException("Received multiple signature keys in dd, only one is allowed");
                    }
                    this.signingKey = new SignatureKey(xMLInputStream);
                } else if (xMLName.getLocalName().equals("SecuritySpec")) {
                    SecuritySpec securitySpec = new SecuritySpec(xMLInputStream, "http://www.openuri.org/2002/11/wsse/spec");
                    this.addSecuritySpec(securitySpec);
                } else {
                    throw new XMLStreamException("Unexpected data in dd -- " + startElement);
                }
            }
            xMLEvent = StreamUtils.skipWS(xMLInputStream, true);
        }
        StreamUtils.closeScope(xMLInputStream, "security");
    }

    public void toXML(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        ArrayList arrayList = new ArrayList(2);
        Attribute[] attributeArray = new Attribute[arrayList.size()];
        arrayList.toArray(attributeArray);
        StreamUtils.addStart(xMLOutputStream, "security", attributeArray);
        this.childrenToXML(xMLOutputStream);
        StreamUtils.addEnd(xMLOutputStream, "security");
    }

    private void childrenToXML(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        if (this.user != null) {
            this.user.toXML(xMLOutputStream);
        }
        if (this.signingKey != null) {
            this.signingKey.toXML(xMLOutputStream);
        }
        if (this.encryptionKey != null) {
            this.encryptionKey.toXML(xMLOutputStream);
        }
        if (this.timestampConfig != null) {
            this.timestampConfig.toXML(xMLOutputStream);
        }
        NamespaceAwareXOS namespaceAwareXOS = new NamespaceAwareXOS(xMLOutputStream);
        namespaceAwareXOS.addPrefix("http://www.openuri.org/2002/11/wsse/spec", "spec");
        Set set = this.specs.entrySet();
        for (Map.Entry entry : set) {
            SecuritySpec securitySpec = (SecuritySpec)entry.getValue();
            securitySpec.toXML(namespaceAwareXOS);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        SecurityDD securityDD = SecurityDD.getDefaultSecurityDD();
        System.out.println(securityDD);
        System.out.println("\nDefault:");
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        securityDD.toXML(xMLOutputStream);
        xMLOutputStream.flush();
        System.out.println("\nDefault with timestamp:");
        securityDD.addSecuritySpec(new SecuritySpec("myID", "http://foo.bar.com/", "me:I"));
        securityDD.setTimestampConfig(new TimestampConfig(true, 100L, false, 1000L, true, 10000L, true));
        xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        securityDD.toXML(xMLOutputStream);
        xMLOutputStream.flush();
    }

    public String toString() {
        return "weblogic.xml.security.specs.SecurityDD{signingKey=" + this.signingKey + ", encryptionKey=" + this.encryptionKey + ", user=" + this.user + ", specs=" + (this.specs == null ? null : "size:" + this.specs.size() + this.specs) + ", timestampConfig=" + this.timestampConfig + "}";
    }
}

