/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import weblogic.xml.security.SecurityConfigurationException;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.specs.BinarySecurityTokenSpec;
import weblogic.xml.security.specs.EncryptionSpec;
import weblogic.xml.security.specs.SignatureSpec;
import weblogic.xml.security.specs.SpecConstants;
import weblogic.xml.security.specs.TimestampConfig;
import weblogic.xml.security.specs.UsernameTokenSpec;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.wsse.Security;
import weblogic.xml.security.wsse.SecurityElementFactory;
import weblogic.xml.security.wsse.Token;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputOutputStream;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.xmlnode.XMLNode;

public class SecuritySpec
implements SpecConstants {
    private String role;
    private String id = "default-spec";
    private String namespace;
    private static final String DEFAULT_NAMESPACE = WSSEConstants.WSSE_URI;
    public static final String DEFAULT_SPEC_ID = "default-spec";
    private BinarySecurityTokenSpec binarySecurityTokenSpec = null;
    private UsernameTokenSpec usernameTokenSpec = null;
    private SignatureSpec signatureSpec = null;
    private EncryptionSpec encryptionSpec = null;
    private static final boolean DEBUG = Security.WSSE_VERBOSE;
    private static final SecurityElementFactory factory = SecurityElementFactory.getDefaultFactory();

    public SecuritySpec() {
        this(null, DEFAULT_NAMESPACE, null);
    }

    public void setRole(String string) {
        this.role = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public SecuritySpec(String string, String string2) {
        this(string, string2, null);
    }

    public SecuritySpec(String string, String string2, String string3) {
        this.id = string;
        this.namespace = string2;
        this.role = string3;
    }

    public SecuritySpec(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public SecuritySpec(XMLInputStream xMLInputStream) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, "http://www.openuri.org/2002/11/wsse/spec");
    }

    public SignatureSpec setSignatureSpec(String string, String string2) {
        return this.setSignatureSpec(string, string2, false);
    }

    public SignatureSpec setSignatureSpec(String string, String string2, boolean bl) {
        return this.setSignatureSpec(new SignatureSpec(string, string2, bl));
    }

    public SignatureSpec setSignatureSpec(SignatureSpec signatureSpec) {
        this.signatureSpec = signatureSpec;
        return this.signatureSpec;
    }

    public UsernameTokenSpec setUsernameTokenSpec(String string) {
        return this.setUsernameTokenSpec(string, null);
    }

    public UsernameTokenSpec setUsernameTokenSpec(String string, String string2) {
        return this.setUsernameTokenSpec(new UsernameTokenSpec(string, string2));
    }

    public UsernameTokenSpec setUsernameTokenSpec(UsernameTokenSpec usernameTokenSpec) {
        this.usernameTokenSpec = usernameTokenSpec;
        return this.usernameTokenSpec;
    }

    public BinarySecurityTokenSpec setBinarySecurityTokenSpec(String string) {
        return this.setBinarySecurityTokenSpec(new BinarySecurityTokenSpec(string, WSSEConstants.ENCODING_BASE64));
    }

    public BinarySecurityTokenSpec setBinarySecurityTokenSpec(BinarySecurityTokenSpec binarySecurityTokenSpec) {
        this.binarySecurityTokenSpec = binarySecurityTokenSpec;
        return this.binarySecurityTokenSpec;
    }

    public EncryptionSpec setEncryptionSpec(String string, X509Certificate x509Certificate) {
        return this.setEncryptionSpec(string, x509Certificate, false);
    }

    public EncryptionSpec setEncryptionSpec(String string, X509Certificate x509Certificate, boolean bl) {
        return this.setEncryptionSpec(new EncryptionSpec(string, x509Certificate, bl));
    }

    public EncryptionSpec setEncryptionSpec(EncryptionSpec encryptionSpec) {
        this.encryptionSpec = encryptionSpec;
        return this.encryptionSpec;
    }

    public String toString() {
        return "weblogic.xml.security.specs.SecuritySpec{role='" + this.role + "'" + ", id='" + this.id + "'" + ", namespace='" + this.namespace + "'" + ", binarySecurityTokenSpec=" + this.binarySecurityTokenSpec + ", usernameTokenSpec=" + this.usernameTokenSpec + ", signatureSpec=" + this.signatureSpec + ", encryptionSpec=" + this.encryptionSpec + "}";
    }

    public String getRole() {
        return this.role;
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public BinarySecurityTokenSpec getBinarySecurityTokenSpec() {
        return this.binarySecurityTokenSpec;
    }

    public UsernameTokenSpec getUsernameTokenSpec() {
        return this.usernameTokenSpec;
    }

    public void setEnablePasswordAuth(boolean bl) {
        if (bl) {
            this.setUsernameTokenSpec(UsernameTokenSpec.getDefaultSpec());
        } else {
            this.setUsernameTokenSpec((UsernameTokenSpec)null);
        }
    }

    public boolean getEnablePasswordAuth() {
        return this.getUsernameTokenSpec() != null;
    }

    public SignatureSpec getSignatureSpec() {
        return this.signatureSpec;
    }

    public EncryptionSpec getEncryptionSpec() {
        return this.encryptionSpec;
    }

    public void toXML(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        this.toXML(xMLOutputStream, "http://www.openuri.org/2002/11/wsse/spec", 0);
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray;
        Object object;
        if (!(xMLOutputStream instanceof NSOutputStream)) {
            object = new NamespaceAwareXOS(xMLOutputStream);
            xMLOutputStream = object;
            object.addPrefix("http://www.openuri.org/2002/11/wsse/spec", "spec");
        }
        object = new ArrayList(3);
        if (this.role != null) {
            attributeArray = ElementFactory.createXMLName(null, "Role", this.getSoapEnvPrefix());
            ((ArrayList)object).add(ElementFactory.createAttribute((XMLName)attributeArray, this.role));
        }
        if (this.namespace != null) {
            ((ArrayList)object).add(ElementFactory.createAttribute("http://www.openuri.org/2002/11/wsse/spec", "Namespace", this.namespace));
        }
        if (this.id != null) {
            ((ArrayList)object).add(ElementFactory.createAttribute("http://www.openuri.org/2002/11/wsse/spec", "Id", this.id));
        }
        attributeArray = new Attribute[((ArrayList)object).size()];
        ((ArrayList)object).toArray(attributeArray);
        int n2 = n + 2;
        StreamUtils.addStart(xMLOutputStream, "http://www.openuri.org/2002/11/wsse/spec", "SecuritySpec", attributeArray, n);
        if (this.usernameTokenSpec != null) {
            this.usernameTokenSpec.toXML(xMLOutputStream, string, n2);
        }
        if (this.binarySecurityTokenSpec != null) {
            this.binarySecurityTokenSpec.toXML(xMLOutputStream, string, n2);
        }
        if (this.signatureSpec != null) {
            this.signatureSpec.toXML(xMLOutputStream, string, n2);
        }
        if (this.encryptionSpec != null) {
            this.encryptionSpec.toXML(xMLOutputStream, string, n2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "SecuritySpec");
    }

    public XMLNode getXMLNode() throws IOException {
        XMLOutputStreamFactory xMLOutputStreamFactory = XMLOutputStreamFactory.newInstance();
        XMLInputOutputStream xMLInputOutputStream = xMLOutputStreamFactory.newInputOutputStream();
        this.toXML((XMLOutputStream)xMLInputOutputStream);
        XMLNode xMLNode = new XMLNode();
        xMLNode.read((XMLInputStream)xMLInputOutputStream);
        xMLNode.addNamespace("spec", "http://www.openuri.org/2002/11/wsse/spec");
        xMLNode.setName("SecuritySpec", "spec", "http://www.openuri.org/2002/11/wsse/spec");
        return xMLNode;
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "SecuritySpec");
        if (startElement == null) {
            throw new XMLStreamException("Did not receive expected SecuritySpec");
        }
        this.id = StreamUtils.getAttribute(startElement, "Id");
        this.namespace = StreamUtils.getAttribute(startElement, "Namespace");
        if (this.namespace == null) {
            this.namespace = DEFAULT_NAMESPACE;
        }
        this.role = StreamUtils.getAttribute(startElement, "Role");
        XMLEvent xMLEvent = StreamUtils.peekElement(xMLInputStream);
        if (xMLEvent.isStartElement() && StreamUtils.matches(xMLEvent, "UsernameTokenSpec", "http://www.openuri.org/2002/11/wsse/spec")) {
            this.usernameTokenSpec = new UsernameTokenSpec(xMLInputStream, string);
            xMLEvent = StreamUtils.peekElement(xMLInputStream);
        }
        if (xMLEvent.isStartElement() && StreamUtils.matches(xMLEvent, "BinarySecurityTokenSpec", "http://www.openuri.org/2002/11/wsse/spec")) {
            this.binarySecurityTokenSpec = new BinarySecurityTokenSpec(xMLInputStream, string);
            xMLEvent = StreamUtils.peekElement(xMLInputStream);
        }
        if (xMLEvent.isStartElement() && StreamUtils.matches(xMLEvent, "SignatureSpec", "http://www.openuri.org/2002/11/wsse/spec")) {
            this.signatureSpec = new SignatureSpec(xMLInputStream, string);
            xMLEvent = StreamUtils.peekElement(xMLInputStream);
        }
        if (xMLEvent.isStartElement() && StreamUtils.matches(xMLEvent, "EncryptionSpec", "http://www.openuri.org/2002/11/wsse/spec")) {
            this.encryptionSpec = new EncryptionSpec(xMLInputStream, string);
            xMLEvent = StreamUtils.peekElement(xMLInputStream);
        }
        StreamUtils.closeScope(xMLInputStream, string, "SecuritySpec");
    }

    private String getSoapEnvPrefix() {
        return "env";
    }

    public final Security createSecurity(String string, TimestampConfig timestampConfig, String string2, String string3, X509Certificate x509Certificate, PrivateKey privateKey, X509Certificate x509Certificate2, SecurityElementFactory securityElementFactory) {
        Security security = securityElementFactory.createSecurity(string);
        if (timestampConfig.generateTimestamp() && this.signatureSpec != null) {
            if (timestampConfig.includeExpiry()) {
                security.addTimestamp(timestampConfig.getValidityPeriod());
            } else {
                security.addTimestamp();
            }
        }
        if (this.usernameTokenSpec != null) {
            if (string2 != null) {
                Token token = securityElementFactory.createToken(string2, string3, this.usernameTokenSpec.getPasswordType());
                security.addToken(token);
            } else {
                throw new SecurityConfigurationException("UsernameToken not provided, but required by service");
            }
        }
        Token token = privateKey != null && x509Certificate2 != null ? securityElementFactory.createToken(x509Certificate2, privateKey) : null;
        if (this.signatureSpec != null) {
            if (token != null) {
                try {
                    security.addSignature(token, this.signatureSpec);
                }
                catch (SecurityProcessingException securityProcessingException) {
                    if (DEBUG) {
                        securityProcessingException.printStackTrace();
                    }
                    throw new SecurityConfigurationException("Unable to add signature to request", (Throwable)((Object)securityProcessingException));
                }
            } else {
                throw new SecurityConfigurationException("Service requires signed requests, but no Token was provided");
            }
        }
        if (this.binarySecurityTokenSpec != null) {
            if (token != null) {
                security.addToken(token);
            } else {
                throw new SecurityConfigurationException("Token not provided, but required by service");
            }
        }
        if (this.encryptionSpec != null) {
            if (x509Certificate == null) {
                throw new SecurityConfigurationException("Service requires encryption but no encryption key was was available for recipient");
            }
            Token token2 = securityElementFactory.createToken(x509Certificate, null);
            try {
                security.addEncryption(token2, this.encryptionSpec);
            }
            catch (SecurityProcessingException securityProcessingException) {
                if (DEBUG) {
                    securityProcessingException.printStackTrace();
                }
                throw new SecurityConfigurationException("Failed adding encryption to request", (Throwable)((Object)securityProcessingException));
            }
        }
        return security;
    }
}

