/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import weblogic.xml.security.specs.ElementIdentifier;
import weblogic.xml.security.specs.OperationSpec;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SignatureSpec
extends OperationSpec {
    private String c14nMethodURI = null;
    private String sigMethodURI = null;
    private static final SignatureSpec DEFAULT_SPEC = new SignatureSpec("http://www.w3.org/2001/10/xml-exc-c14n#", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", true);

    public SignatureSpec(String string, String string2) {
        this(string, string2, false);
    }

    public SignatureSpec(String string, String string2, boolean bl) {
        this.c14nMethodURI = string;
        this.sigMethodURI = string2;
        this.setEntireBody(bl);
    }

    public SignatureSpec(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public String getSignatureMethod() {
        return this.sigMethodURI;
    }

    public String getCanonicalizationMethod() {
        return this.c14nMethodURI;
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "SignatureSpec");
        if (startElement == null) {
            throw new XMLStreamException("Expected SignatureSpec, got " + startElement);
        }
        this.sigMethodURI = StreamUtils.getAttribute(startElement, "SignatureMethod");
        StreamUtils.requiredAttr(this.sigMethodURI, "SignatureSpec", "SignatureMethod");
        this.c14nMethodURI = StreamUtils.getAttribute(startElement, "CanonicalizationMethod");
        StreamUtils.requiredAttr(this.sigMethodURI, "SignatureSpec", "CanonicalizationMethod");
        this.setEntireBody("true".equals(StreamUtils.getAttribute(startElement, "SignBody")));
        XMLEvent xMLEvent = StreamUtils.peekElement(xMLInputStream);
        while (!xMLEvent.isEndElement()) {
            if (xMLEvent.isStartElement() && StreamUtils.matches(xMLEvent, "ElementIdentifier", string)) {
                ElementIdentifier elementIdentifier = new ElementIdentifier(xMLInputStream, string);
                String string2 = elementIdentifier.getRestriction();
                if (string2 == null) {
                    this.addUnrestrictedType(elementIdentifier);
                } else if ("body".equals(string2)) {
                    this.addBodyElement(elementIdentifier);
                } else {
                    this.addHeaderElement(elementIdentifier);
                }
                xMLEvent = StreamUtils.peekElement(xMLInputStream);
                continue;
            }
            StreamUtils.discard(xMLInputStream);
            xMLEvent = StreamUtils.peekElement(xMLInputStream);
        }
        StreamUtils.closeScope(xMLInputStream, string, "SignatureSpec");
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Object object;
        if (!(xMLOutputStream instanceof NSOutputStream)) {
            object = new NamespaceAwareXOS(xMLOutputStream);
            xMLOutputStream = object;
            object.addPrefix("http://www.openuri.org/2002/11/wsse/spec", "spec");
        }
        object = new Attribute[]{ElementFactory.createAttribute(string, "SignatureMethod", this.sigMethodURI), ElementFactory.createAttribute(string, "CanonicalizationMethod", this.c14nMethodURI), ElementFactory.createAttribute(string, "SignBody", this.entireBody() ? "true" : "false")};
        StreamUtils.addStart(xMLOutputStream, string, "SignatureSpec", (Attribute[])object, n);
        int n2 = n + 2;
        for (ElementIdentifier elementIdentifier : this.headerList) {
            elementIdentifier.toXML(xMLOutputStream, string, n2);
        }
        for (ElementIdentifier elementIdentifier : this.bodyList) {
            elementIdentifier.toXML(xMLOutputStream, string, n2);
        }
        for (ElementIdentifier elementIdentifier : this.unrestrictedList) {
            elementIdentifier.toXML(xMLOutputStream, string, n2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "SignatureSpec", n);
    }

    public static final SignatureSpec getDefaultSpec() {
        return DEFAULT_SPEC;
    }

    static {
        DEFAULT_SPEC.addElement(WSUConstants.WSU_URI, "Timestamp", null);
    }
}

