/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.webservice.core.handler.TimestampHandler;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.specs.SecuritySpec;
import weblogic.xml.security.specs.SignatureSpec;
import weblogic.xml.security.specs.SpecConstants;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.utils.ValidationException;
import weblogic.xml.security.utils.XMLReader;
import weblogic.xml.security.utils.XMLSerializable;
import weblogic.xml.security.utils.XMLWriter;
import weblogic.xml.security.wsse.Security;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.security.wsu.Created;
import weblogic.xml.security.wsu.Timestamp;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public final class TimestampConfig
extends XMLSerializable
implements SpecConstants {
    private boolean clockSynchronized;
    private long clockPrecision;
    private boolean laxPrecision;
    private long maxProcessingDelay;
    private boolean generateTimestamp;
    private long validityPeriod;
    private boolean timestampRequired;
    public static final String ASSUME_SYNCHRONIZED_CLOCKS = "weblogic.webservice.security.clock.synchronized";
    public static final String CLOCK_PRECISION = "weblogic.webservice.security.clock.precision";
    public static final String LAX_CLOCK_PRECISION = "weblogic.webservice.security.clock.precision.lax";
    public static final String MAX_PROCESSING_DELAY = "weblogic.webservice.security.delay.max";
    public static final String GENERATE_TIMESTAMP = "weblogic.webservice.security.timestamp.include";
    public static final String VALIDITY_PERIOD = "weblogic.webservice.security.validity";
    public static final String REQUIRE_TIMESTAMP = "weblogic.webservice.security.timestamp.require";
    public static final int NO_MAX_PROCESSING_DELAY = -1;
    public static final int NO_EXPIRATION = -1;
    private static final QName FAILED_CHECK = Utils.getQName(WSSEConstants.QNAME_FAULT_FAILEDCHECK);

    public TimestampConfig(XMLInputStream xMLInputStream) throws XMLStreamException {
        this();
        this.fromXMLInternal(xMLInputStream);
    }

    public TimestampConfig(XMLReader xMLReader) throws ValidationException {
        this();
        this.fromXMLInternal(xMLReader);
    }

    public TimestampConfig() {
        boolean bl = Boolean.getBoolean(ASSUME_SYNCHRONIZED_CLOCKS);
        Integer n = Integer.getInteger(CLOCK_PRECISION);
        long l = n != null ? n.longValue() : 60000L;
        boolean bl2 = Boolean.getBoolean(LAX_CLOCK_PRECISION);
        Integer n2 = Integer.getInteger(MAX_PROCESSING_DELAY);
        int n3 = n2 != null ? n2 : -1;
        Integer n4 = Integer.getInteger(VALIDITY_PERIOD);
        int n5 = n4 != null ? n4 : -1;
        String string = System.getProperty(GENERATE_TIMESTAMP);
        boolean bl3 = string == null || string.equalsIgnoreCase("true");
        String string2 = System.getProperty(REQUIRE_TIMESTAMP);
        boolean bl4 = string2 == null || string.equalsIgnoreCase("true");
        this.clockSynchronized = bl;
        this.clockPrecision = l;
        this.laxPrecision = bl2;
        this.maxProcessingDelay = n3;
        this.generateTimestamp = bl3;
        this.validityPeriod = n5;
        this.timestampRequired = bl4;
        this.checkConfig();
    }

    public TimestampConfig(boolean bl, long l, boolean bl2, long l2, boolean bl3, long l3, boolean bl4) {
        this.clockSynchronized = bl;
        this.clockPrecision = l > 0L ? l : 1L;
        this.laxPrecision = bl2;
        this.maxProcessingDelay = l2;
        this.generateTimestamp = bl3;
        this.validityPeriod = l3;
        this.timestampRequired = bl4;
        this.checkConfig();
    }

    private void checkConfig() {
        if (!this.clockSynchronized) {
            if (this.maxProcessingDelay > -1L) {
                throw new AssertionError((Object)"Cannot specify a maximum processing delay if clocks are not synchronized");
            }
            if (this.validityPeriod > -1L && this.generateTimestamp) {
                throw new AssertionError((Object)"Cannot specify a validityPeriod if clocks are not synchronized");
            }
        }
        if (!this.laxPrecision && this.maxProcessingDelay != -1L && this.maxProcessingDelay < this.clockPrecision) {
            throw new AssertionError((Object)"Cannot enforce a maximum processing delay that is smaller than clock precision unless lax enforcement of clock precision has been enabled");
        }
    }

    public boolean isClockSynchronized() {
        return this.clockSynchronized;
    }

    public long getMaxProcessingDelay() {
        return this.maxProcessingDelay;
    }

    public long getRoundedMaxDelay() {
        return this.maxProcessingDelay / this.clockPrecision;
    }

    public long getClockPrecision() {
        return this.clockPrecision;
    }

    public boolean laxClockPrecision() {
        return this.laxPrecision;
    }

    public boolean generateTimestamp() {
        return this.generateTimestamp;
    }

    public boolean includeExpiry() {
        return this.validityPeriod != -1L;
    }

    public long getValidityPeriod() {
        return this.validityPeriod;
    }

    public boolean isFreshnessEnforced() {
        return this.maxProcessingDelay != -1L;
    }

    public void setClockSynchronized(boolean bl) {
        this.clockSynchronized = bl;
    }

    public void setClockPrecision(long l) {
        this.clockPrecision = l;
    }

    public long getRoundedTime(Calendar calendar) {
        long l = calendar.getTimeInMillis();
        return l / this.clockPrecision;
    }

    public void setLaxPrecision(boolean bl) {
        this.laxPrecision = bl;
    }

    public void setMaxProcessingDelay(long l) {
        this.maxProcessingDelay = l;
    }

    public void setGenerateTimestamp(boolean bl) {
        this.generateTimestamp = bl;
    }

    public void setValidityPeriod(long l) {
        this.validityPeriod = l;
    }

    public boolean isTimestampRequired() {
        return this.timestampRequired;
    }

    public void setTimestampRequired(boolean bl) {
        this.timestampRequired = bl;
    }

    public String toString() {
        return "weblogic.xml.security.specs.TimestampConfig{timestampRequired=" + this.timestampRequired + ", clockSynchronized=" + this.clockSynchronized + ", clockPrecision=" + this.clockPrecision + ", laxPrecision=" + this.laxPrecision + ", maxProcessingDelay=" + this.maxProcessingDelay + ", generateTimestamp=" + this.generateTimestamp + ", validityPeriod=" + this.validityPeriod + "}";
    }

    public void toXML(XMLWriter xMLWriter) {
        xMLWriter.writeStartElement(null, "timestamp");
        this.writeBoolean(xMLWriter, "clocks-synchronized", this.clockSynchronized);
        if (this.clockPrecision != 60000L) {
            this.writeLong(xMLWriter, "clock-precision", this.clockPrecision);
        }
        if (this.laxPrecision) {
            this.writeBoolean(xMLWriter, "enforce-precision", this.laxPrecision);
        }
        if (this.maxProcessingDelay != -1L) {
            this.writeLong(xMLWriter, "inbound-expiry", this.maxProcessingDelay);
        }
        if (!this.generateTimestamp) {
            this.writeBoolean(xMLWriter, "generate-signature-timestamp", this.generateTimestamp);
        }
        if (this.validityPeriod != -1L) {
            this.writeLong(xMLWriter, "outbound-expiry", this.validityPeriod);
        }
        if (!this.timestampRequired) {
            this.writeBoolean(xMLWriter, "require-signature-timestamp", this.timestampRequired);
        }
        xMLWriter.writeEndElement();
    }

    private void writeBoolean(XMLWriter xMLWriter, String string, boolean bl) {
        xMLWriter.writeStartElement(null, string);
        xMLWriter.writeCharacters(Boolean.toString(bl));
        xMLWriter.writeEndElement();
    }

    private void writeLong(XMLWriter xMLWriter, String string, long l) {
        xMLWriter.writeStartElement(null, string);
        xMLWriter.writeCharacters(Long.toString(l));
        xMLWriter.writeEndElement();
    }

    public TimestampConfig copy() {
        return new TimestampConfig(this.clockSynchronized, this.clockPrecision, this.laxPrecision, this.maxProcessingDelay, this.generateTimestamp, this.validityPeriod, this.timestampRequired);
    }

    protected void fromXMLInternal(XMLReader xMLReader) throws ValidationException {
        HashSet hashSet = new HashSet(7);
        xMLReader.require(2, null, "timestamp");
        int n = xMLReader.next();
        while (n != 4) {
            if (n == 16) {
                throw new ValidationException("Unexpected CharacterData in TimestampConfig");
            }
            String string = xMLReader.getLocalName();
            if (string.equals("clocks-synchronized")) {
                this.clockSynchronized = this.readBoolean("clocks-synchronized", xMLReader, hashSet);
            } else if (string.equals("clock-precision")) {
                this.clockPrecision = this.readLong("clock-precision", xMLReader, hashSet);
            } else if (string.equals("enforce-precision")) {
                this.laxPrecision = this.readBoolean("enforce-precision", xMLReader, hashSet);
            } else if (string.equals("inbound-expiry")) {
                this.maxProcessingDelay = this.readLong("inbound-expiry", xMLReader, hashSet);
            } else if (string.equals("generate-signature-timestamp")) {
                this.generateTimestamp = this.readBoolean("generate-signature-timestamp", xMLReader, hashSet);
            } else if (string.equals("outbound-expiry")) {
                this.validityPeriod = this.readLong("outbound-expiry", xMLReader, hashSet);
            } else if (string.equals("require-signature-timestamp")) {
                this.timestampRequired = this.readBoolean("require-signature-timestamp", xMLReader, hashSet);
            } else {
                throw new ValidationException("Unexpected data in dd -- " + string);
            }
            n = xMLReader.next();
        }
        xMLReader.require(4, null, "timestamp");
    }

    private long readLong(String string, XMLReader xMLReader, Set set) throws ValidationException {
        return Long.parseLong(this.readString(string, xMLReader, set));
    }

    private boolean readBoolean(String string, XMLReader xMLReader, Set set) throws ValidationException {
        return Boolean.valueOf(this.readString(string, xMLReader, set));
    }

    private String readString(String string, XMLReader xMLReader, Set set) throws ValidationException {
        if (set.contains(string)) {
            throw new ValidationException("Timestamp configuration contains multiple " + string);
        }
        xMLReader.require(2, null, string);
        xMLReader.next();
        xMLReader.require(16, null, null);
        String string2 = xMLReader.getText();
        xMLReader.next();
        xMLReader.require(4, null, string);
        set.add(string);
        return string2;
    }

    public void checkExpiration(Calendar calendar, Calendar calendar2, Calendar calendar3) {
        long l = this.getRoundedTime(calendar);
        long l2 = this.getRoundedTime(calendar2);
        long l3 = calendar3 != null ? this.getRoundedTime(calendar3) : 0L;
        if (!this.isClockSynchronized()) {
            if (calendar3 != null) {
                throw new SOAPFaultException(TimestampHandler.EXPIRED_FAULTCODE, "Message includes expiry but clocks are not synchronized", null, null);
            }
        } else {
            long l4;
            if (this.isFreshnessEnforced() && (l4 = l2 + this.getRoundedMaxDelay()) < l) {
                throw new SOAPFaultException(TimestampHandler.EXPIRED_FAULTCODE, "Message is too old", null, null);
            }
            if (l < l2) {
                throw new SOAPFaultException(TimestampHandler.EXPIRED_FAULTCODE, "Message Created time in the future", null, null);
            }
            if (calendar3 != null) {
                if (!this.laxClockPrecision() && l3 <= l2) {
                    throw new SOAPFaultException(TimestampHandler.EXPIRED_FAULTCODE, "Message is expired: clock precision insufficient to distinguish Created time from Expires time", null, null);
                }
                if (l3 < l) {
                    throw new SOAPFaultException(TimestampHandler.EXPIRED_FAULTCODE, "Message Expires time has passed", null, null);
                }
            }
        }
    }

    public void checkTimestamps(Security security, MessageContext messageContext) {
        Object object;
        Object object2;
        Object object3;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance(WSUConstants.TZ_ZULU);
        Calendar calendar2 = null;
        Object object4 = null;
        Iterator iterator = security.getTimestamps();
        while (iterator.hasNext()) {
            object3 = (Timestamp)iterator.next();
            Created created = object3.getCreated();
            object2 = created.getTime();
            hashMap.put("#" + object3.getId(), object3);
            hashMap.put("#" + created.getId(), object2);
            object = object3.getExpires();
            Calendar calendar3 = object != null ? object.getTime() : null;
            if (object4 == null || ((Calendar)object4).after(object2)) {
                object4 = object2;
            }
            if (calendar2 != null && (calendar3 == null || !calendar2.after(calendar3))) continue;
            calendar2 = calendar3;
        }
        if (object4 != null) {
            this.checkExpiration(calendar, (Calendar)object4, calendar2);
        }
        messageContext.setProperty("weblogic.webservice.timestamp.received", (Object)calendar);
        messageContext.setProperty("weblogic.webservice.timestamp.created", object4);
        if (calendar2 != null) {
            messageContext.setProperty("weblogic.webservice.timestamp.expires", calendar2);
        }
        if (this.isTimestampRequired()) {
            iterator = security.getSignatures();
            while (iterator.hasNext()) {
                object3 = (Signature)iterator.next();
                boolean bl = false;
                object2 = ((Signature)object3).getReferences();
                while (object2.hasNext()) {
                    object = (Reference)object2.next();
                    if (!hashMap.containsKey(((Reference)object).getURI())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new SOAPFaultException(FAILED_CHECK, "Signature did not cover a timestamp; cannot determine freshness", security.getRole(), null);
            }
        }
    }

    public void addTimestamp(SecuritySpec securitySpec, Security security) {
        SignatureSpec signatureSpec = securitySpec.getSignatureSpec();
        if (signatureSpec != null && this.generateTimestamp()) {
            if (!signatureSpec.contains(WSUConstants.WSU_URI, "Timestamp", null)) {
                signatureSpec.addElement(WSUConstants.WSU_URI, "Timestamp", null);
            }
            if (this.includeExpiry()) {
                security.addTimestamp(this.getValidityPeriod());
            } else {
                security.addTimestamp();
            }
        }
    }
}

