/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.specs;

import java.util.ArrayList;
import weblogic.xml.security.specs.SpecBase;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class UsernameTokenSpec
extends SpecBase {
    private String passType = null;
    private String realm = null;
    private static final UsernameTokenSpec DEFAULT_SPEC = new UsernameTokenSpec(WSSEConstants.PASSWORDTYPE_PASSWORDTEXT);

    public UsernameTokenSpec(String string) {
        this.passType = string;
    }

    public UsernameTokenSpec(String string, String string2) {
        this(string);
        this.realm = string2;
    }

    public UsernameTokenSpec(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public String getPasswordType() {
        return this.passType;
    }

    public String getRealm() {
        return this.realm;
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "UsernameTokenSpec");
        this.passType = StreamUtils.getAttribute(startElement, "PasswordType");
        StreamUtils.requiredAttr(this.passType, "UsernameTokenSpec", "PasswordType");
        this.realm = StreamUtils.getAttribute(startElement, "Realm");
        StreamUtils.closeScope(xMLInputStream, string, "UsernameTokenSpec");
    }

    public void toXML(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        this.toXML(xMLOutputStream, "http://www.openuri.org/2002/11/wsse/spec", 0);
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray;
        Attribute[] attributeArray2;
        ArrayList arrayList = new ArrayList();
        if (xMLOutputStream instanceof NSOutputStream) {
            attributeArray2 = (Attribute[])xMLOutputStream;
        } else {
            attributeArray2 = new NamespaceAwareXOS(xMLOutputStream);
            xMLOutputStream = attributeArray2;
            attributeArray2.addPrefix("http://www.openuri.org/2002/11/wsse/spec", "spec");
            attributeArray2.addPrefix(WSSEConstants.WSSE_URI, "wsse");
        }
        attributeArray2 = new Attribute[arrayList.size()];
        arrayList.toArray(attributeArray2);
        if (this.realm == null) {
            attributeArray = new Attribute[1];
        } else {
            attributeArray = new Attribute[2];
            attributeArray[1] = ElementFactory.createAttribute(string, "Realm", this.realm);
        }
        attributeArray[0] = StreamUtils.createAttribute("PasswordType", this.passType);
        StreamUtils.addStart(xMLOutputStream, string, "UsernameTokenSpec", attributeArray, attributeArray2, n);
        StreamUtils.addEnd(xMLOutputStream, string, "UsernameTokenSpec");
    }

    public static UsernameTokenSpec getDefaultSpec() {
        return DEFAULT_SPEC;
    }

    public String toString() {
        return "weblogic.xml.security.specs.UsernameTokenSpec{passType=" + this.passType + ", realm='" + this.realm + "'" + "}";
    }
}

