/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.transforms;

import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import weblogic.xml.babel.stream.CanonicalWriter;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.security.transforms.IncompatibleTransformException;
import weblogic.xml.security.transforms.NodeTransform;
import weblogic.xml.security.transforms.OctetTransform;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class C14NTransform
extends NodeTransform {
    protected OctetTransform dest;
    protected Map nsMap = null;
    protected final boolean withComments;

    public C14NTransform(boolean bl, boolean bl2) {
        this(bl2);
    }

    public C14NTransform(boolean bl) {
        this.withComments = bl;
    }

    public void setNamespaces(Map map) {
        this.nsMap = map;
    }

    public Map getNamespaces() {
        Map map = this.nsMap == null ? Collections.EMPTY_MAP : this.nsMap;
        return map;
    }

    public XMLOutputStream getXMLOutputStream() throws XMLStreamException {
        OutputStreamWriter outputStreamWriter;
        try {
            outputStreamWriter = new OutputStreamWriter(this.dest.getOutputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        CanonicalWriter canonicalWriter = new CanonicalWriter((Writer)outputStreamWriter, this.nsMap);
        if (this.withComments) {
            canonicalWriter.setWriteComments(this.withComments);
        }
        return new XMLOutputStreamBase((XMLWriter)canonicalWriter);
    }

    public String getURI() {
        if (this.withComments) {
            return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
        }
        return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    }

    public void setDest(OctetTransform octetTransform) {
        this.dest = octetTransform;
    }

    public void setDest(NodeTransform nodeTransform) throws IncompatibleTransformException {
        throw new IncompatibleTransformException("Cannot chain " + this + " to " + nodeTransform);
    }
}

