/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.transforms;

import java.util.Map;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.security.transforms.NodeTransform;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class EnvelopedSignatureTransform
extends NodeTransform {
    public static final String XPATH_PROPERTY_NAME = "xpath";
    private NodeTransform dest;
    private StartElement startEvent = null;

    public XMLOutputStream getXMLOutputStream() throws XMLStreamException {
        return new SignatureStrippingStream(this.startEvent, this.dest.getXMLOutputStream());
    }

    public String getURI() {
        return "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    }

    public void setParentSignature(StartElement startElement) {
        this.startEvent = startElement;
    }

    public void setNamespaces(Map map) {
        this.dest.setNamespaces(map);
    }

    public void setDest(NodeTransform nodeTransform) {
        this.dest = nodeTransform;
    }

    private static class SignatureStrippingStream
    extends XMLOutputStreamBase {
        private XMLOutputStream dest = null;
        private StartElement sigStart = null;
        private boolean matched = false;
        private int depth = 0;

        public SignatureStrippingStream(StartElement startElement, XMLOutputStream xMLOutputStream) {
            this.sigStart = startElement;
            this.dest = xMLOutputStream;
        }

        public void addXMLEvent(XMLEvent xMLEvent) throws XMLStreamException {
            if (this.matched || this.depth == 0) {
                this.dest.add(xMLEvent);
                return;
            }
            if (this.depth > 0) {
                if (xMLEvent.isStartElement()) {
                    ++this.depth;
                } else if (xMLEvent.isEndElement()) {
                    --this.depth;
                }
                if (this.depth == 0) {
                    this.matched = true;
                }
                this.dest.add(xMLEvent);
                return;
            }
            if (xMLEvent == this.sigStart) {
                ++this.depth;
                this.dest.add(xMLEvent);
            }
        }

        public void flush() throws XMLStreamException {
            this.lastStartElement = null;
            this.dest.flush();
        }

        public void close() throws XMLStreamException {
            this.flush();
            this.dest.close();
        }

        public void close(boolean bl) throws XMLStreamException {
            if (bl) {
                this.flush();
            }
            this.dest.close(bl);
        }
    }
}

