/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.transforms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weblogic.xml.security.transforms.ExcC14NTransform;
import weblogic.xml.security.utils.Observer;
import weblogic.xml.security.utils.ScopedNamespaceContext;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public class ExcC14NSignObserver
implements Observer {
    private int nesting = 0;
    private final ExcC14NTransform c14n;
    private final ScopedNamespaceContext context;
    private final ScopedNamespaceContext visiblyUsed;
    private final Map nonVisiblyUsed;
    private Map parentNamespaces;
    private static final String XMLNS = "xmlns";
    private static final String PREFIX_SEP = ":";
    private static final String DEFAULT_NS_PREFIX = "";

    public ExcC14NSignObserver(ExcC14NTransform excC14NTransform) {
        this.c14n = excC14NTransform;
        this.nonVisiblyUsed = new HashMap();
        this.context = new ScopedNamespaceContext();
        this.visiblyUsed = new ScopedNamespaceContext();
    }

    public boolean observe(XMLEvent xMLEvent) throws XMLStreamException {
        boolean bl = true;
        switch (xMLEvent.getType()) {
            case 2: {
                StartElement startElement = (StartElement)xMLEvent;
                if (this.nesting == 0) {
                    this.initNamespaces(startElement);
                }
                this.openScope(startElement);
                this.checkAttributes(startElement.getAttributes());
                break;
            }
            case 4: {
                bl = this.closeScope();
                if (bl) break;
                this.c14n.setInclusiveNamespaceMap(this.nonVisiblyUsed.isEmpty() ? null : this.nonVisiblyUsed);
                break;
            }
        }
        return bl;
    }

    private boolean closeScope() {
        --this.nesting;
        this.visiblyUsed.closeScope();
        this.context.closeScope();
        return this.nesting > 0;
    }

    private void openScope(StartElement startElement) {
        Attribute attribute;
        ++this.nesting;
        this.context.openScope();
        this.visiblyUsed.openScope();
        this.addVisiblyUsed(startElement.getName());
        AttributeIterator attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            attribute = attributeIterator.next();
            this.addVisiblyUsed(attribute.getName());
        }
        attribute = startElement.getNamespaces();
        while (attribute.hasNext()) {
            Attribute attribute2 = attribute.next();
            XMLName xMLName = attribute2.getName();
            String string = xMLName.getLocalName();
            if (XMLNS.equals(string)) {
                this.context.bindDefaultNamespace(attribute2.getValue());
                continue;
            }
            this.context.bindNamespace(string, attribute2.getValue());
        }
    }

    private void addVisiblyUsed(XMLName xMLName) {
        String string;
        String string2 = xMLName.getPrefix();
        if (string2 != null && (string = this.visiblyUsed.getNamespaceURI(string2)) == null) {
            if (DEFAULT_NS_PREFIX.equals(string2)) {
                this.visiblyUsed.bindDefaultNamespace(xMLName.getNamespaceUri());
            } else {
                this.visiblyUsed.bindNamespace(string2, xMLName.getNamespaceUri());
            }
        }
    }

    private void initNamespaces(StartElement startElement) {
        Map map = startElement.getNamespaceMap();
        if (map != null) {
            this.parentNamespaces = new HashMap();
            this.parentNamespaces.putAll(map);
        } else {
            this.parentNamespaces = Collections.EMPTY_MAP;
        }
        this.context.openScope();
        this.visiblyUsed.openScope();
        Set set = this.parentNamespaces.entrySet();
        for (Map.Entry entry : set) {
            String string = (String)entry.getKey();
            if (DEFAULT_NS_PREFIX.equals(string)) {
                this.context.bindDefaultNamespace((String)entry.getValue());
                continue;
            }
            this.context.bindNamespace(string, (String)entry.getValue());
        }
    }

    private void checkAttributes(AttributeIterator attributeIterator) {
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            XMLName xMLName = attribute.getName();
            if (!ExcC14NTransform.QNAME_VALUE_ATTRIBUTES.contains(xMLName)) continue;
            this.addNonVisiblyUsed(ExcC14NSignObserver.parsePrefix(attribute.getValue()));
        }
    }

    private void addNonVisiblyUsed(String string) {
        String string2;
        if (string != null && (string2 = this.context.getNamespaceURI(string)) != null) {
            this.nonVisiblyUsed.put(string, string2);
        }
    }

    private static String parsePrefix(String string) {
        int n = string.indexOf(PREFIX_SEP);
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return DEFAULT_NS_PREFIX;
        }
        return string.substring(0, n);
    }

    public boolean consumes() {
        return false;
    }
}

