/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.transforms;

import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.utils.Debug;
import weblogic.xml.babel.stream.ExclusiveCanonicalWriter;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.schema.binding.internal.SoapTypes;
import weblogic.xml.schema.binding.util.StdNamespace;
import weblogic.xml.schema.types.XSDNMTokens;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.transforms.C14NTransform;
import weblogic.xml.security.transforms.ExcC14NSignObserver;
import weblogic.xml.security.transforms.ExcC14NVerifyObserver;
import weblogic.xml.security.transforms.Transform;
import weblogic.xml.security.transforms.TransformException;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.Observer;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.XMLStreamObserver;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class ExcC14NTransform
extends C14NTransform {
    public static final String INCLUSIVE_NAMESPACES_PROPERTY_NAME = "InclusiveNamespaces";
    private String[] inclusiveNamespaces = null;
    private Map inclusiveNamespaceMap;
    private static final String TAG_INCLUSIVE_NAMESPACES = "InclusiveNamespaces";
    private static final String ATTR_PREFIX_LIST = "PrefixList";
    public static final String EXC_C14N_DEFAULT_PREFIX = "#default";
    public static final String EXC_C14N_PREFIX = "c14n";
    private static final String XSI_NAMESPACE = StdNamespace.instance().schemaInstance();
    private static final String XSD_TYPE = "type";
    private static final XMLName XSD_TYPE_NAME = ElementFactory.createXMLName(XSI_NAMESPACE, "type", null);
    private static final XMLName SOAP_ARRAYTYPE_NAME = SoapTypes.SoapArrayType;
    public static final List QNAME_VALUE_ATTRIBUTES = new ArrayList();

    public ExcC14NTransform(boolean bl) {
        super(bl);
    }

    public XMLOutputStream getXMLOutputStream() throws XMLStreamException {
        OutputStreamWriter outputStreamWriter;
        try {
            outputStreamWriter = new OutputStreamWriter(this.dest.getOutputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        ExcC14NTransform.printInclusiveNamespacesPrefixList(this.inclusiveNamespaces);
        ExclusiveCanonicalWriter exclusiveCanonicalWriter = new ExclusiveCanonicalWriter((Writer)outputStreamWriter, this.getNamespaces(), this.inclusiveNamespaces);
        if (this.withComments) {
            exclusiveCanonicalWriter.setWriteComments(this.withComments);
        }
        return new XMLOutputStreamBase((XMLWriter)exclusiveCanonicalWriter);
    }

    private static void printInclusiveNamespacesPrefixList(String[] stringArray) {
        if (VERBOSE) {
            String string = "";
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i != 0) {
                        string = string + " ";
                    }
                    string = string + stringArray[i];
                }
            } else {
                string = "null";
            }
            Debug.say((String)(" +++ inclusiveNamespaces : " + string));
        }
    }

    public String getURI() {
        if (this.withComments) {
            return "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
        }
        return "http://www.w3.org/2001/10/xml-exc-c14n#";
    }

    protected void toXMLInternal(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        if (this.inclusiveNamespaces != null) {
            Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute(ATTR_PREFIX_LIST, XSDNMTokens.getCanonicalXml((String[])this.inclusiveNamespaces))};
            StreamUtils.addElement(xMLOutputStream, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", null, attributeArray, n, 2);
        }
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        if (StreamUtils.peekElement(xMLInputStream, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces")) {
            XMLEvent xMLEvent = StreamUtils.getElement(xMLInputStream, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
            String string2 = StreamUtils.getAttributeByName(ATTR_PREFIX_LIST, null, (StartElement)xMLEvent);
            try {
                if (string2 != null) {
                    this.setParameter("InclusiveNamespaces", string2);
                }
            }
            catch (TransformException transformException) {
                throw new XMLStreamException((Throwable)((Object)transformException));
            }
            StreamUtils.closeScope(xMLInputStream, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
        }
    }

    public void setParameter(String string, String string2) throws TransformException {
        if (!string.equalsIgnoreCase("InclusiveNamespaces")) {
            throw new TransformException("Unknown property: " + string + "=" + string2);
        }
        this.inclusiveNamespaces = XSDNMTokens.convertXml((String)string2, (String)EXC_C14N_DEFAULT_PREFIX);
    }

    public String[] getInclusiveNamespaces() {
        return this.inclusiveNamespaces;
    }

    public void setInclusiveNamespaceMap(Map map) {
        this.inclusiveNamespaceMap = map;
        if (map != null && this.inclusiveNamespaces == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry stringArray2 : map.entrySet()) {
                String string = (String)stringArray2.getKey();
                if (string == null || "".equals(string)) {
                    arrayList.add(EXC_C14N_PREFIX);
                    continue;
                }
                arrayList.add(string);
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            this.inclusiveNamespaces = stringArray;
        }
    }

    public static void setupSign(XMLStreamObserver xMLStreamObserver, String string, Reference reference) {
        Transform[] transformArray = reference.getTransforms();
        for (int i = 0; i < transformArray.length; ++i) {
            Transform transform = transformArray[i];
            if (!(transform instanceof ExcC14NTransform)) continue;
            xMLStreamObserver.add(string, (Observer)new ExcC14NSignObserver((ExcC14NTransform)transform));
        }
    }

    public static void setupVerify(XMLStreamObserver xMLStreamObserver, String string, Reference reference) {
        Transform[] transformArray = reference.getTransforms();
        for (int i = 0; i < transformArray.length; ++i) {
            Transform transform = transformArray[i];
            if (!(transform instanceof ExcC14NTransform)) continue;
            ExcC14NTransform excC14NTransform = (ExcC14NTransform)transform;
            if (excC14NTransform.inclusiveNamespaces == null) continue;
            xMLStreamObserver.add(string, (Observer)new ExcC14NVerifyObserver(excC14NTransform));
        }
    }

    public static final void registerQNameAttribute(String string, String string2) {
        XMLName xMLName = ElementFactory.createXMLName(string, string2);
        if (!QNAME_VALUE_ATTRIBUTES.contains(xMLName)) {
            QNAME_VALUE_ATTRIBUTES.add(xMLName);
        }
    }

    static {
        QNAME_VALUE_ATTRIBUTES.add(XSD_TYPE_NAME);
        QNAME_VALUE_ATTRIBUTES.add(SOAP_ARRAYTYPE_NAME);
    }
}

