/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.transforms;

import java.util.Map;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.transforms.C14NTransform;
import weblogic.xml.security.transforms.EnvelopedSignatureTransform;
import weblogic.xml.security.transforms.ExcC14NTransform;
import weblogic.xml.security.transforms.IncompatibleTransformException;
import weblogic.xml.security.transforms.NodeTransform;
import weblogic.xml.security.transforms.OctetTransform;
import weblogic.xml.security.transforms.TransformException;
import weblogic.xml.security.transforms.XPathTransform;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public abstract class Transform
implements DSIGConstants {
    protected static final XMLOutputStreamFactory xfactory = XMLOutputStreamFactory.newInstance();
    private static final String W3 = "http://www.w3.org";
    public static final String XPATH = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String W3C_C14N = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String W3C_C14N_WC = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String W3C_EXC_C14N = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String W3C_EXC_C14N_WC = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String ENVELOPED = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";

    public static Transform getTransform(String string) throws TransformException {
        if (string.equals(XPATH)) {
            return new XPathTransform();
        }
        if (string.equals(W3C_C14N)) {
            return new C14NTransform(false);
        }
        if (string.equals(W3C_C14N_WC)) {
            return new C14NTransform(true);
        }
        if (string.equals(ENVELOPED)) {
            return new EnvelopedSignatureTransform();
        }
        if (string.equals(W3C_EXC_C14N)) {
            return new ExcC14NTransform(false);
        }
        if (string.equals(W3C_EXC_C14N_WC)) {
            return new ExcC14NTransform(true);
        }
        throw new TransformException("Unknown Transform: " + string);
    }

    public abstract String getURI();

    public void setParameter(String string, String string2) throws TransformException {
    }

    public abstract void setNamespaces(Map var1);

    public abstract XMLOutputStream getXMLOutputStream() throws XMLStreamException;

    public final void setDest(Transform transform) throws IncompatibleTransformException {
        if (transform instanceof NodeTransform) {
            this.setDest((NodeTransform)transform);
        } else {
            this.setDest((OctetTransform)transform);
        }
    }

    protected abstract void setDest(NodeTransform var1) throws IncompatibleTransformException;

    protected abstract void setDest(OctetTransform var1) throws IncompatibleTransformException;

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute("Algorithm", this.getURI())};
        StreamUtils.addStart(xMLOutputStream, string, "Transform", attributeArray, n);
        this.toXMLInternal(xMLOutputStream, string, n);
        StreamUtils.addEnd(xMLOutputStream, string, "Transform", n);
    }

    static Transform fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        Transform transform = null;
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "Transform");
        if (startElement != null) {
            String string2 = StreamUtils.getAttribute(startElement, "Algorithm");
            StreamUtils.requiredAttr(string2, "Transform", "Algorithm");
            transform = Transform.getTransform(string2);
            transform.fromXMLInternal(xMLInputStream, string);
            StreamUtils.closeScope(xMLInputStream, string, "Transform");
        }
        return transform;
    }

    protected void toXMLInternal(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<Transform Algorithm=\"http://www.w3.org/TR/1999/REC-xpath-19991116\">\n  <XPath>\n    self::text()\n  </XPath>\n</Transform>\n");
        Transform transform = Transform.fromXML(xMLInputStream, "http://www.w3.org/2000/09/xmldsig#");
        System.out.println(transform);
        System.out.println("Implemented by: " + transform.getClass().getName());
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        transform.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }
}

