/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.transforms.IncompatibleTransformException;
import weblogic.xml.security.transforms.NodeTransform;
import weblogic.xml.security.transforms.OctetTransform;
import weblogic.xml.security.transforms.Transform;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class Transforms
implements DSIGConstants {
    List transforms = new ArrayList();
    private static final boolean VERBOSE = false;
    private static final XMLInputStreamFactory inFactory = XMLInputStreamFactory.newInstance();
    private Map namespaces = null;

    public Transforms() {
    }

    private Transforms(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public void add(Transform transform) throws IncompatibleTransformException {
        if (this.transforms.size() == 0) {
            this.transforms.add(transform);
        } else {
            Transform transform2 = (Transform)this.transforms.get(this.transforms.size() - 1);
            transform2.setDest(transform);
            this.transforms.add(transform);
        }
    }

    public Transform remove(Transform transform) throws IncompatibleTransformException {
        int n = this.transforms.indexOf(transform);
        if (n == -1) {
            return null;
        }
        Transform transform2 = null;
        if (n < this.transforms.size() - 2) {
            transform2 = (Transform)this.transforms.get(n + 1);
        }
        if (n > 1) {
            Transform transform3 = (Transform)this.transforms.get(n - 1);
            transform3.setDest(transform2);
        }
        return (Transform)this.transforms.remove(n);
    }

    public final Transform[] getTransforms() {
        Transform[] transformArray = new Transform[this.transforms.size()];
        transformArray = this.transforms.toArray(transformArray);
        return transformArray;
    }

    public XMLOutputStream getXMLOutputStream() throws XMLStreamException {
        Transform transform = this.getHead();
        if (transform == null) {
            return null;
        }
        return transform.getXMLOutputStream();
    }

    public void setNamespaces(Map map) {
        this.namespaces = map;
        Transform transform = this.getHead();
        if (transform == null) {
            return;
        }
        transform.setNamespaces(map);
    }

    public void perform(InputStream inputStream) throws XMLStreamException, IOException {
        Transform transform = this.getHead();
        if (transform == null) {
            return;
        }
        if (transform instanceof NodeTransform) {
            NodeTransform nodeTransform = (NodeTransform)transform;
            XMLInputStream xMLInputStream = null;
            xMLInputStream = this.namespaces == null ? inFactory.newInputStream(inputStream) : inFactory.newFragmentInputStream(inputStream, this.namespaces);
            XMLOutputStream xMLOutputStream = nodeTransform.getXMLOutputStream();
            xMLOutputStream.add(xMLInputStream);
            xMLOutputStream.flush();
        } else {
            OctetTransform octetTransform = (OctetTransform)transform;
            OutputStream outputStream = octetTransform.getOutputStream();
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            outputStream.close();
        }
    }

    public int size() {
        return this.transforms.size();
    }

    public Transform get(int n) {
        return (Transform)this.transforms.get(n);
    }

    private Transform getHead() {
        if (this.transforms.size() < 1) {
            return null;
        }
        return (Transform)this.transforms.get(0);
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        if (this.transforms.size() < 1) {
            return;
        }
        StreamUtils.addStart(xMLOutputStream, string, "Transforms", n);
        for (int i = 0; i < this.size(); ++i) {
            Transform transform = this.get(i);
            transform.toXML(xMLOutputStream, string, n + 2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, "Transforms", n);
    }

    public static Transforms fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        if (StreamUtils.peekElement(xMLInputStream, string, "Transforms")) {
            return new Transforms(xMLInputStream, string);
        }
        return null;
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        Transform transform;
        xMLInputStream.skip();
        while ((transform = Transform.fromXML(xMLInputStream, string)) != null) {
            try {
                this.add(transform);
            }
            catch (IncompatibleTransformException incompatibleTransformException) {
                throw new XMLStreamException((Throwable)((Object)incompatibleTransformException));
            }
        }
        StreamUtils.closeScope(xMLInputStream, string, "Transforms");
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<Transforms xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n  <Transform Algorithm=\"http://www.w3.org/TR/1999/REC-xpath-19991116\">\n    <XPath>\n      self::text()\n    </XPath>\n  </Transform>\n</Transforms>\n");
        Transforms transforms = (Transforms)DSIGReader.read(xMLInputStream, 12);
        System.out.println(transforms);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        transforms.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", 0);
        xMLOutputStream.flush();
    }
}

