/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.transforms;

import java.util.Map;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.security.transforms.NodeTransform;
import weblogic.xml.security.transforms.TransformException;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.xpath.StreamXPath;
import weblogic.xml.xpath.XPathException;
import weblogic.xml.xpath.XPathStreamFactory;
import weblogic.xml.xpath.XPathStreamObserver;

public class XPathTransform
extends NodeTransform
implements DSIGConstants {
    private static final String XPATH_PROPERTY_NAME = "xpath";
    private NodeTransform dest;
    private StreamXPath xpath;

    protected XPathTransform() {
    }

    public XMLOutputStream getXMLOutputStream() throws XMLStreamException {
        XPathStreamFactory xPathStreamFactory = new XPathStreamFactory();
        XMLOutputStream xMLOutputStream = this.dest.getXMLOutputStream();
        ObserverWriter observerWriter = new ObserverWriter(xMLOutputStream);
        xPathStreamFactory.install(this.xpath, (XPathStreamObserver)observerWriter);
        return xPathStreamFactory.createStream((XMLOutputStream)observerWriter);
    }

    public String getURI() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    public void setParameter(String string, String string2) throws TransformException {
        if (string.equalsIgnoreCase(XPATH_PROPERTY_NAME)) {
            try {
                this.xpath = new StreamXPath(string2);
            }
            catch (XPathException xPathException) {
                throw new TransformException("cannot create XPath transform", xPathException);
            }
        } else {
            throw new TransformException("Unknown property: " + string + "=" + string2);
        }
    }

    public void setNamespaces(Map map) {
        this.dest.setNamespaces(map);
    }

    public void setDest(NodeTransform nodeTransform) {
        this.dest = nodeTransform;
    }

    protected void toXMLInternal(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        if (this.xpath != null) {
            StreamUtils.addElement(xMLOutputStream, string, "XPath", this.xpath.toString(), n, 2);
        }
    }

    protected void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        String string2 = StreamUtils.getValue(xMLInputStream, string, "XPath");
        try {
            this.setParameter(XPATH_PROPERTY_NAME, string2);
        }
        catch (TransformException transformException) {
            throw new XMLStreamException((Throwable)((Object)transformException));
        }
        StreamUtils.required(string2, "XPathTransform", "XPath");
    }

    public String toString() {
        return "XPathTransform: " + this.xpath;
    }

    private static class ObserverWriter
    implements XMLOutputStream,
    XPathStreamObserver {
        private final XMLOutputStream dest;
        private XMLStreamException cachedException;

        public ObserverWriter(XMLOutputStream xMLOutputStream) {
            this.dest = xMLOutputStream;
        }

        public void observe(XMLEvent xMLEvent) {
            try {
                this.dest.add(xMLEvent);
            }
            catch (XMLStreamException xMLStreamException) {
                this.cachedException = xMLStreamException;
            }
        }

        public void observeAttribute(StartElement startElement, Attribute attribute) {
        }

        public void observeNamespace(StartElement startElement, Attribute attribute) {
        }

        public void add(XMLEvent xMLEvent) throws XMLStreamException {
            if (this.cachedException != null) {
                throw this.cachedException;
            }
        }

        public void add(XMLInputStream xMLInputStream) throws XMLStreamException {
            if (this.cachedException != null) {
                throw this.cachedException;
            }
        }

        public void add(String string) throws XMLStreamException {
            if (this.cachedException != null) {
                throw this.cachedException;
            }
        }

        public void add(Attribute attribute) throws XMLStreamException {
            if (this.cachedException != null) {
                throw this.cachedException;
            }
        }

        public void close() throws XMLStreamException {
            this.dest.close();
        }

        public void close(boolean bl) throws XMLStreamException {
            this.dest.close(bl);
        }

        public void flush() throws XMLStreamException {
            this.dest.flush();
        }
    }
}

