/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import weblogic.xml.security.utils.ScopedNamespaceContext;
import weblogic.xml.security.utils.XMLWriter;
import weblogic.xml.security.utils.XMLWriterRuntimeException;

public abstract class AbstractXMLWriter
implements XMLWriter {
    private ScopedNamespaceContext nsContext = new ScopedNamespaceContext();
    private Map defaultPrefixes = Collections.EMPTY_MAP;
    private int prefixCount = 0;

    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLWriterRuntimeException, IllegalStateException;

    public void writeAttribute(String string, String string2, QName qName) throws XMLWriterRuntimeException, IllegalStateException {
        this.writeAttribute(string, string2, this.convertQName(qName));
    }

    public abstract void writeCharacters(String var1) throws XMLWriterRuntimeException;

    public void writeCharacters(QName qName) throws XMLWriterRuntimeException, IllegalStateException {
        this.writeCharacters(this.convertQName(qName));
    }

    public void setPrefix(String string, String string2) throws XMLWriterRuntimeException {
        this.bindNamespace(string, string2);
    }

    public void setDefaultNamespace(String string) throws XMLWriterRuntimeException {
        this.bindDefaultNamespace(string);
    }

    public Map getNamespaceMap() {
        return this.nsContext.getNamespaceMap();
    }

    public void setNamespaceMap(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("namespace map cannot be null");
        }
        for (Map.Entry entry : map.entrySet()) {
            this.nsContext.bindNamespace((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setDefaultPrefixes(Map map) {
        this.defaultPrefixes = map;
    }

    private String convertQName(QName qName) throws XMLWriterRuntimeException {
        String string = qName.getNamespaceURI();
        if (string == null || string.equals("")) {
            return qName.getLocalPart();
        }
        String string2 = this.findOrBindNamespace(string);
        String string3 = "".equals(string2) ? qName.getLocalPart() : string2 + ":" + qName.getLocalPart();
        return string3;
    }

    protected final String findPrefix(String string) {
        return this.nsContext.getPrefix(string);
    }

    protected final void addNamespacePrefix(String string, String string2) {
        this.nsContext.bindNamespace(string, string2);
    }

    protected final void addDefaultNamespace(String string) {
        this.nsContext.bindDefaultNamespace(string);
    }

    protected final void openScope() {
        this.nsContext.openScope();
    }

    protected final void closeScope() {
        this.nsContext.closeScope();
    }

    protected final String generatePrefix(String string) {
        String string2 = (String)this.defaultPrefixes.get(string);
        return string2 != null ? string2 : "n" + this.prefixCount++;
    }

    protected abstract void bindNamespace(String var1, String var2) throws XMLWriterRuntimeException;

    protected abstract void bindDefaultNamespace(String var1) throws XMLWriterRuntimeException;

    protected final String findOrBindNamespace(String string) throws XMLWriterRuntimeException {
        String string2 = this.findPrefix(string);
        if (string2 == null) {
            string2 = this.generatePrefix(string);
            this.bindNamespace(string2, string);
        }
        return string2;
    }
}

