/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.HashMap;
import java.util.Map;
import weblogic.xml.security.utils.StartEventDelegate;
import weblogic.xml.security.utils.XMLEventBuffer;
import weblogic.xml.security.utils.XMLInputStreamBase;
import weblogic.xml.stream.ChangePrefixMapping;
import weblogic.xml.stream.EndPrefixMapping;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class EventBufferInputStream
extends XMLInputStreamBase {
    private static final XMLInputStreamFactory factory = XMLInputStreamFactory.newInstance();
    private final Map namespaceMap = new HashMap();
    private final XMLEventBuffer b;
    private XMLEvent peek = null;

    public EventBufferInputStream(XMLEventBuffer xMLEventBuffer, XMLInputStream xMLInputStream) {
        super(xMLInputStream);
        this.b = xMLEventBuffer;
    }

    public static XMLInputStream reconstitute(XMLEventBuffer xMLEventBuffer, XMLInputStream xMLInputStream) throws XMLStreamException {
        return factory.newBufferedInputStream((XMLInputStream)new EventBufferInputStream(xMLEventBuffer, xMLInputStream));
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.peek != null) {
            return this.peek;
        }
        if (!this.b.hasNext()) {
            return this.source.peek();
        }
        this.peek = this.next();
        return this.peek;
    }

    public XMLEvent next() throws XMLStreamException {
        if (this.peek != null) {
            XMLEvent xMLEvent = this.peek;
            this.peek = null;
            return xMLEvent;
        }
        if (!this.b.hasNext()) {
            return this.source.next();
        }
        XMLEvent xMLEvent = this.b.next();
        switch (xMLEvent.getType()) {
            case 1024: {
                StartPrefixMapping startPrefixMapping = (StartPrefixMapping)xMLEvent;
                this.namespaceMap.put(startPrefixMapping.getPrefix(), startPrefixMapping.getNamespaceUri());
                break;
            }
            case 4096: {
                ChangePrefixMapping changePrefixMapping = (ChangePrefixMapping)xMLEvent;
                this.namespaceMap.put(changePrefixMapping.getPrefix(), changePrefixMapping.getNewNamespaceUri());
                break;
            }
            case 2048: {
                EndPrefixMapping endPrefixMapping = (EndPrefixMapping)xMLEvent;
                this.namespaceMap.remove(endPrefixMapping.getPrefix());
            }
        }
        if (xMLEvent.isStartElement()) {
            return new StartEventDelegate((StartElement)xMLEvent, this.namespaceMap);
        }
        return xMLEvent;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.peek != null || this.b.hasNext() || this.source.hasNext();
    }

    public XMLInputStream getSubStream() throws XMLStreamException {
        throw new UnsupportedOperationException("substreams not currently supported on this stream type");
    }
}

