/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.MutableAttribute;
import weblogic.xml.security.utils.MutableEnd;
import weblogic.xml.security.utils.MutableStart;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.PrefixableName;
import weblogic.xml.security.utils.QNameAttribute;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class NamespaceAwareXOS
extends XMLOutputStreamBase
implements NSOutputStream {
    private static final int INITIAL_STACK_SIZE = 32;
    private static final String XMLNS = "xmlns";
    private static final Map DEFAULT_PREFIX_MAP = new HashMap(5);
    private static final String DEFAULT_PREFIX = "ns";
    private XMLOutputStream dest;
    private int nestingLevel = -1;
    private final Map nsMap = new HashMap();
    private int[] nesting = new int[32];
    private String[] ns = new String[32];
    private int sp = 0;
    private Map prefixMap = new HashMap();
    private int prefixCount = 1;
    private StartElement lastStart;
    private MutableStart mutableStart;

    public NamespaceAwareXOS(XMLOutputStream xMLOutputStream) {
        this.dest = xMLOutputStream;
        this.prefixMap.putAll(DEFAULT_PREFIX_MAP);
    }

    public NamespaceAwareXOS(XMLOutputStream xMLOutputStream, Map map) {
        this(xMLOutputStream);
        this.nsMap.putAll(this.reverse(map));
    }

    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        if (!this.cacheEmpty()) {
            super.add(this.clearCache());
        }
        switch (xMLEvent.getType()) {
            case 2: {
                StartElement startElement = (StartElement)xMLEvent;
                this.openScope(startElement);
                this.cache(startElement);
                break;
            }
            case 4: {
                super.add(xMLEvent);
                this.closeScope();
                break;
            }
            default: {
                super.add(xMLEvent);
            }
        }
    }

    public void add(Attribute attribute) throws XMLStreamException {
        if (this.cacheEmpty()) {
            throw new AssertionError((Object)"Last event was not a StartElement event -- cannot write attribute");
        }
        if (this.mutableStart == null) {
            this.mutableStart = this.getModifiableStart(this.lastStart);
            this.lastStart = this.mutableStart;
        }
        this.mutableStart.addAttribute(attribute);
    }

    private void cache(StartElement startElement) {
        this.lastStart = startElement;
        this.mutableStart = null;
    }

    private XMLEvent clearCache() {
        StartElement startElement = this.lastStart;
        this.mutableStart = null;
        this.lastStart = null;
        return startElement;
    }

    private boolean cacheEmpty() {
        return this.lastStart == null;
    }

    protected void addXMLEvent(XMLEvent xMLEvent) throws XMLStreamException {
        Object object;
        switch (xMLEvent.getType()) {
            case 2: {
                if (!(xMLEvent instanceof MutableStart)) {
                    object = xMLEvent;
                    break;
                }
                MutableStart mutableStart = (MutableStart)xMLEvent;
                XMLName xMLName = xMLEvent.getName();
                object = mutableStart;
                if (!mutableStart.attributesNamespaced()) {
                    AttributeIterator attributeIterator = mutableStart.getAttributes();
                    ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
                    while (attributeIterator.hasNext()) {
                        Attribute attribute = this.fixAttributeNamespace(attributeIterator.next(), mutableStart, xMLName);
                        arrayList.add(attribute);
                    }
                    mutableStart.setAttributes(arrayList);
                    mutableStart.markAttributesNamespaced();
                }
                if (mutableStart.namespaced()) break;
                mutableStart.setName(this.fillPrefix(xMLName, mutableStart));
                mutableStart.markNamespaced();
                break;
            }
            case 4: {
                MutableEnd mutableEnd;
                object = xMLEvent;
                if (!(xMLEvent instanceof MutableEnd) || (mutableEnd = (MutableEnd)xMLEvent).namespaced()) break;
                mutableEnd.setName(this.fillPrefix(mutableEnd.getName(), null));
                mutableEnd.markNamespaced();
                break;
            }
            default: {
                object = xMLEvent;
            }
        }
        this.dest.add(object);
    }

    private Attribute fixAttributeNamespace(Attribute attribute, MutableStart mutableStart, XMLName xMLName) {
        String string;
        QNameAttribute qNameAttribute;
        if (attribute instanceof QNameAttribute) {
            qNameAttribute = (QNameAttribute)attribute;
            qNameAttribute.setQNameValue(this.fillPrefix(qNameAttribute.getQNameValue(), mutableStart));
        }
        if ((string = (qNameAttribute = attribute.getName()).getNamespaceUri()) != null) {
            qNameAttribute = this.fillPrefix((XMLName)qNameAttribute, mutableStart);
            if (attribute instanceof MutableAttribute) {
                ((MutableAttribute)attribute).setName((XMLName)qNameAttribute);
            }
        }
        return attribute;
    }

    private MutableEnd getMutableEnd(EndElement endElement) {
        if (endElement instanceof MutableEnd) {
            return (MutableEnd)endElement;
        }
        return new MutableEnd(endElement);
    }

    private XMLName fillPrefix(XMLName xMLName, MutableStart mutableStart) {
        String string = xMLName.getNamespaceUri();
        XMLName xMLName2 = xMLName;
        if (string != null) {
            String string2 = xMLName.getPrefix();
            if (string2 != null) {
                String string3 = (String)this.nsMap.get(string);
                if (string3 == null) {
                    this.addNamespace(mutableStart, string2, string);
                } else if (!string3.equals(string2)) {
                    xMLName2 = NamespaceAwareXOS.fillInPrefix(xMLName, string3);
                } else {
                    this.bindInScope(string, string2);
                }
            } else {
                string2 = (String)this.nsMap.get(string);
                if (string2 == null) {
                    string2 = (String)this.prefixMap.get(string);
                    if (string2 == null) {
                        string2 = this.generatePrefix();
                    }
                    this.addNamespace(mutableStart, string2, string);
                } else {
                    this.bindInScope(string, string2);
                }
                if (!XMLNS.equals(string2)) {
                    xMLName2 = NamespaceAwareXOS.fillInPrefix(xMLName, string2);
                }
            }
        }
        return xMLName2;
    }

    private void addNamespace(MutableStart mutableStart, String string, String string2) {
        if (mutableStart == null) {
            throw new AssertionError((Object)"StartElement cannot be null");
        }
        mutableStart.addNamespace(ElementFactory.createNamespaceAttribute(string, string2));
        this.bindInScope(string2, string);
    }

    private MutableStart getModifiableStart(StartElement startElement) {
        if (startElement instanceof MutableStart) {
            return (MutableStart)startElement;
        }
        return new MutableStart(startElement);
    }

    private static XMLName fillInPrefix(XMLName xMLName, String string) {
        PrefixableName prefixableName = xMLName instanceof PrefixableName ? (PrefixableName)xMLName : new PrefixableName(xMLName);
        prefixableName.setPrefix(string);
        return prefixableName;
    }

    public void addPrefix(String string, String string2) {
        this.prefixMap.put(string, string2);
    }

    public Map getNamespaces() {
        return this.reverse(this.nsMap);
    }

    private Map reverse(Map map) {
        HashMap hashMap = new HashMap();
        for (Object k : map.keySet()) {
            String string = (String)map.get(k);
            if (XMLNS.equals(string)) {
                string = "";
            }
            hashMap.put(string, k);
        }
        return hashMap;
    }

    private void openScope(StartElement startElement) {
        ++this.nestingLevel;
        AttributeIterator attributeIterator = startElement.getNamespaces();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            this.bindInScope(attribute.getValue(), attribute.getName().getLocalName());
        }
    }

    private void closeScope() {
        String string;
        if (this.nestingLevel < 0) {
            throw new AssertionError((Object)"Attempted to close scope, but none are opend");
        }
        while ((string = this.popNS(this.nestingLevel)) != null) {
            this.nsMap.remove(string);
        }
        --this.nestingLevel;
    }

    private void bindInScope(String string, String string2) {
        if (this.nestingLevel < 0) {
            throw new AssertionError((Object)"Attempting to add namespace without an open scope");
        }
        String string3 = this.nsMap.put(string, string2);
        if (string3 == null) {
            this.pushNS(this.nestingLevel, string);
        }
    }

    private void pushNS(int n, String string) {
        if (this.sp >= this.nesting.length - 1) {
            int n2 = this.nesting.length * 2;
            int[] nArray = new int[n2];
            String[] stringArray = new String[n2];
            System.arraycopy(this.nesting, 0, nArray, 0, this.nesting.length);
            System.arraycopy(this.ns, 0, stringArray, 0, this.ns.length);
            this.nesting = nArray;
            this.ns = stringArray;
        }
        this.nesting[this.sp] = n;
        this.ns[this.sp++] = string;
    }

    private String popNS(int n) {
        if (this.sp == 0) {
            return null;
        }
        if (this.nesting[this.sp - 1] == n) {
            return this.ns[--this.sp];
        }
        return null;
    }

    private String generatePrefix() {
        return DEFAULT_PREFIX + this.prefixCount++;
    }

    public void flush() throws XMLStreamException {
        this.dest.flush();
    }

    public void close() throws XMLStreamException {
        this.flush();
        this.dest.close();
    }

    public void close(boolean bl) throws XMLStreamException {
        if (bl) {
            this.flush();
        }
        this.dest.close(bl);
    }

    static {
        DEFAULT_PREFIX_MAP.put(WSSEConstants.WSSE_URI, "wsse");
        DEFAULT_PREFIX_MAP.put(WSUConstants.WSU_URI, "wsu");
        DEFAULT_PREFIX_MAP.put("http://www.w3.org/2000/09/xmldsig#", "dsig");
        DEFAULT_PREFIX_MAP.put("http://www.w3.org/2001/04/xmlenc#", "xenc");
        DEFAULT_PREFIX_MAP.put("http://www.w3.org/2001/10/xml-exc-c14n#", "c14n");
    }
}

