/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import weblogic.xml.security.utils.Observer;
import weblogic.xml.security.utils.XMLInputStreamBase;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class ObservedXMLInputStream
extends XMLInputStreamBase {
    private Observer observer;

    public ObservedXMLInputStream(XMLInputStream xMLInputStream, Observer observer) {
        super(xMLInputStream);
        if (observer == null) {
            throw new IllegalArgumentException("observer cannot be null");
        }
        this.observer = observer;
    }

    public XMLEvent next() throws XMLStreamException {
        boolean bl;
        XMLEvent xMLEvent = this.source.next();
        if (this.observer != null && !(bl = this.observer.observe(xMLEvent))) {
            this.observer = null;
        }
        return xMLEvent;
    }
}

