/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import weblogic.utils.collections.Stack;
import weblogic.webservice.core.soap.NameImpl;
import weblogic.webservice.core.soap.SOAPTextElement;
import weblogic.xml.security.utils.AbstractXMLReader;
import weblogic.xml.security.utils.ValidationException;

public class SOAPElementReader
extends AbstractXMLReader {
    private final Stack stateStack = new Stack();
    private StateFrame currentFrame;
    private SOAPTextElement textElement;
    private int state;

    public SOAPElementReader(SOAPElement sOAPElement) {
        if (sOAPElement == null) {
            throw new IllegalArgumentException("element cannot be null");
        }
        this.currentFrame = new StateFrame(sOAPElement);
        this.state = 2;
        this.textElement = null;
    }

    public int next() {
        switch (this.state) {
            case 4: {
                if (this.stateStack.isEmpty()) {
                    this.close();
                    return this.state;
                }
                this.currentFrame = (StateFrame)this.stateStack.pop();
            }
            case 16: {
                this.textElement = null;
            }
            case 2: {
                int n;
                if (!this.currentFrame.children.hasNext()) {
                    n = 4;
                } else {
                    Object e = this.currentFrame.children.next();
                    if (e instanceof SOAPTextElement) {
                        this.textElement = (SOAPTextElement)e;
                        n = 16;
                    } else if (e instanceof SOAPElement) {
                        this.stateStack.push((Object)this.currentFrame);
                        this.currentFrame = new StateFrame((SOAPElement)e);
                        n = 2;
                    } else {
                        throw new AssertionError((Object)("Unknown child type: " + e));
                    }
                }
                this.state = n;
                return this.state;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalStateException("Reader in illegal state");
    }

    public boolean hasName() {
        return this.state == 2 || this.state == 4;
    }

    public QName getName() throws IllegalStateException {
        if (!this.hasName()) {
            throw new IllegalStateException("Current node has no name");
        }
        return qnameFactory.getQName(this.getNamespaceURI(), this.getLocalName());
    }

    public String getLocalName() {
        if (!this.hasName()) {
            throw new IllegalStateException("Current node has no name");
        }
        return this.currentFrame.element.getElementName().getLocalName();
    }

    public String getNamespaceURI() {
        if (!this.hasName()) {
            throw new IllegalStateException("Current node has no name");
        }
        return this.currentFrame.element.getElementName().getURI();
    }

    public void require(int n, String string, String string2) throws ValidationException {
        String string3;
        String string4;
        block0 : switch (n) {
            case 2: {
                string4 = "<" + string + ":" + string2 + ">";
                switch (this.state) {
                    case 2: {
                        if (string2.equals(this.getLocalName()) && (string == null || string.equals(this.getNamespaceURI()))) {
                            return;
                        }
                        string3 = "<" + this.getName() + ">";
                        break block0;
                    }
                    case 4: {
                        string3 = "</" + this.getName() + ">";
                        break block0;
                    }
                    case 16: {
                        string3 = "CDATA (" + this.textElement + ")";
                        break block0;
                    }
                }
                string3 = "end of document";
                break;
            }
            case 4: {
                string4 = "</" + string + ":" + string2 + ">";
                switch (this.state) {
                    case 2: {
                        string3 = "<" + this.getName() + ">";
                        break block0;
                    }
                    case 4: {
                        if (string2.equals(this.getLocalName()) && (string == null || string.equals(this.getNamespaceURI()))) {
                            return;
                        }
                        string3 = "</" + this.getName() + ">";
                        break block0;
                    }
                    case 16: {
                        string3 = "CDATA (" + this.textElement + ")";
                        break block0;
                    }
                }
                string3 = "end of document";
                break;
            }
            case 16: {
                string4 = "CDATA";
                switch (this.state) {
                    case 16: {
                        return;
                    }
                    case 2: {
                        string3 = "<" + this.getName() + ">";
                        break block0;
                    }
                    case 4: {
                        string3 = "</" + this.getName() + ">";
                        break block0;
                    }
                }
                string3 = "end of document";
                break;
            }
            case 0: {
                string4 = "end of document";
                switch (this.state) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        string3 = "<" + this.getName() + ">";
                        break block0;
                    }
                    case 4: {
                        string3 = "</" + this.getName() + ">";
                        break block0;
                    }
                }
                string3 = "CDATA";
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal type provided - " + n);
            }
        }
        throw new ValidationException("expected " + string4 + ", got " + string3);
    }

    public void close() {
        this.state = 0;
        this.currentFrame = null;
        this.stateStack.clear();
    }

    public int getEventType() {
        return this.state;
    }

    public boolean isStartElement() {
        return this.state == 2;
    }

    public boolean isEndElement() {
        return this.state == 4;
    }

    public boolean isCharacters() {
        return this.state == 16;
    }

    public String getAttribute(QName qName) {
        return this.getAttribute(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public String getAttribute(String string, String string2) throws IllegalStateException {
        if (this.state != 2 && this.state != 4) {
            throw new IllegalStateException("No attributes available for this type");
        }
        NameImpl nameImpl = new NameImpl(string2, null, string);
        return this.currentFrame.element.getAttributeValue((Name)nameImpl);
    }

    public QName getQNameAttribute(QName qName) throws IllegalStateException {
        String string = this.getAttribute(qName);
        return this.getQName(string);
    }

    public String getNamespaceURI(String string) {
        return this.currentFrame.element.getNamespaceURI(string);
    }

    public Map getNamespaceMap() {
        Iterator iterator = this.currentFrame.element.getNamespacePrefixes();
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.currentFrame.element.getNamespaceURI(string);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public String getText() throws IllegalStateException {
        if (this.state != 16) {
            throw new IllegalStateException();
        }
        String string = this.textElement.getValue();
        return string;
    }

    private static final class StateFrame {
        private final SOAPElement element;
        private final Iterator children;

        private StateFrame(SOAPElement sOAPElement) {
            this.element = sOAPElement;
            this.children = sOAPElement.getChildElements();
        }
    }
}

