/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import weblogic.utils.collections.Stack;
import weblogic.webservice.core.soap.NameImpl;
import weblogic.webservice.core.soap.SOAPElementImpl;
import weblogic.xml.security.utils.AbstractXMLWriter;
import weblogic.xml.security.utils.XMLWriterRuntimeException;

public class SOAPElementWriter
extends AbstractXMLWriter {
    protected static final String DEFAULT_NAMESPACE = "";
    private final SOAPElement root;
    private SOAPElement parent;

    public SOAPElementWriter(SOAPElement sOAPElement) {
        if (sOAPElement == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        this.openScope();
        this.parent = sOAPElement;
        this.root = sOAPElement;
        Stack stack = new Stack();
        SOAPElement sOAPElement2 = this.root;
        do {
            stack.push((Object)sOAPElement2);
        } while ((sOAPElement2 = sOAPElement2.getParentElement()) != null);
        do {
            sOAPElement2 = (SOAPElement)stack.pop();
            Iterator iterator = sOAPElement2.getNamespacePrefixes();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.addNamespacePrefix(string, this.root.getNamespaceURI(string));
            }
        } while (!stack.isEmpty());
    }

    public void writeStartElement(String string, String string2) {
        if (this.parent == null) {
            throw new XMLWriterRuntimeException("Only a single child can be written");
        }
        String string3 = this.findPrefix(string);
        if (string3 == null) {
            string3 = this.generatePrefix(string);
            try {
                this.parent = this.parent.addChildElement(string2, string3, string);
                this.openScope();
                this.bindNamespace(string3, string);
            }
            catch (SOAPException sOAPException) {
                throw new XMLWriterRuntimeException(sOAPException);
            }
        }
        try {
            this.parent = this.parent.addChildElement(string2, string3, string);
            this.openScope();
        }
        catch (SOAPException sOAPException) {
            throw new XMLWriterRuntimeException(sOAPException);
        }
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLWriterRuntimeException, IllegalStateException {
        if (this.parent == null) {
            throw new XMLWriterRuntimeException("Only a single child can be written");
        }
        String string4 = this.findOrBindNamespace(string);
        try {
            this.parent.addAttribute((Name)new NameImpl(string2, string4, string), string3);
        }
        catch (SOAPException sOAPException) {
            throw new XMLWriterRuntimeException(sOAPException);
        }
    }

    public void writeCharacters(String string) throws XMLWriterRuntimeException {
        if (this.parent == null) {
            throw new XMLWriterRuntimeException("Only a single child can be written");
        }
        try {
            this.parent.addTextNode(string);
        }
        catch (SOAPException sOAPException) {
            throw new XMLWriterRuntimeException(sOAPException);
        }
    }

    public void writeEndElement() throws XMLWriterRuntimeException {
        if (this.parent == null) {
            throw new XMLWriterRuntimeException("Only a single child can be written");
        }
        if (this.parent == this.root) {
            throw new XMLWriterRuntimeException("Unbalaneced end element");
        }
        this.closeScope();
        this.parent = this.parent.getParentElement();
    }

    public void flush() throws XMLWriterRuntimeException {
    }

    public void close() throws XMLWriterRuntimeException {
        this.flush();
    }

    protected void bindNamespace(String string, String string2) throws XMLWriterRuntimeException {
        if (DEFAULT_NAMESPACE.equals(string)) {
            this.bindDefaultNamespace(string2);
            return;
        }
        try {
            this.parent.addNamespaceDeclaration(string, string2);
        }
        catch (SOAPException sOAPException) {
            throw new XMLWriterRuntimeException(sOAPException);
        }
        this.addNamespacePrefix(string, string2);
    }

    protected void bindDefaultNamespace(String string) throws XMLWriterRuntimeException {
        try {
            this.parent.addNamespaceDeclaration(DEFAULT_NAMESPACE, string);
        }
        catch (SOAPException sOAPException) {
            throw new XMLWriterRuntimeException(sOAPException);
        }
        this.addDefaultNamespace(string);
    }

    public SOAPElement getSOAPElement() {
        return this.root;
    }

    public static void main(String[] stringArray) {
        SOAPElementWriter sOAPElementWriter;
        SOAPElementWriter sOAPElementWriter2 = sOAPElementWriter = new SOAPElementWriter((SOAPElement)new SOAPElementImpl());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uri:ns2", "myPrefix");
        sOAPElementWriter.setDefaultPrefixes(hashMap);
        sOAPElementWriter2.writeStartElement("uri:ns1", "foo");
        sOAPElementWriter2.writeAttribute("uri:ns1", "bar", "myValue");
        sOAPElementWriter2.writeAttribute("uri:ns2", "baz", "myValue2");
        sOAPElementWriter2.writeStartElement("uri:ns2", "boo");
        sOAPElementWriter2.writeAttribute("uri:ns3", "blah", "myValue3");
        sOAPElementWriter2.writeCharacters("this is my text");
        sOAPElementWriter2.writeEndElement();
        sOAPElementWriter2.writeEndElement();
        SOAPElement sOAPElement = sOAPElementWriter2.getSOAPElement();
        System.out.println(sOAPElement.toString());
    }
}

