/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.utils.collections.ArraySet;
import weblogic.utils.collections.Stack;

public class ScopedNamespaceContext {
    public static final String DEFAULT_NAMESPACE = "";
    private final Stack scopeStack;
    private LLNamespaceContext current = null;

    public ScopedNamespaceContext() {
        this(null, new Stack());
    }

    private ScopedNamespaceContext(LLNamespaceContext lLNamespaceContext, Stack stack) {
        this.current = lLNamespaceContext;
        this.scopeStack = stack;
    }

    public void clear() {
        this.scopeStack.clear();
        this.current = null;
    }

    public String getNamespaceURI(String string) {
        if (this.current == null) {
            return null;
        }
        return this.current.getNamespaceURI(string);
    }

    public String getPrefix(String string) {
        if (this.current == null) {
            return null;
        }
        return this.current.getPrefix(string);
    }

    public Iterator getPrefixes(String string) {
        if (this.current == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.current.getPrefixes(string);
    }

    public boolean scopeOpened() {
        return !this.scopeStack.isEmpty();
    }

    public void openScope() {
        this.scopeStack.push((Object)this.current);
    }

    public void closeScope() {
        LLNamespaceContext lLNamespaceContext;
        if (!this.scopeOpened()) {
            throw new IllegalStateException("no scope currently open");
        }
        this.current = lLNamespaceContext = (LLNamespaceContext)this.scopeStack.pop();
    }

    public void bindNamespace(String string, String string2) {
        if (string == DEFAULT_NAMESPACE || string == null) {
            throw new IllegalArgumentException("Cannot use empty string or null as a prefix; use bindDefaultNamespace() to bind the default namespace");
        }
        this.bindNamespaceInternal(string, string2);
    }

    private void bindNamespaceInternal(String string, String string2) {
        if (!this.scopeOpened()) {
            throw new IllegalStateException("no scope currently open");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null namespace not allowed");
        }
        this.current = new LLNamespaceContext(string, string2, this.current);
    }

    public void unbindNamespace(String string) {
        this.bindNamespace(string, null);
    }

    public void bindDefaultNamespace(String string) {
        this.bindNamespaceInternal(DEFAULT_NAMESPACE, string);
    }

    public void unbindDefaultNamespace() {
        this.bindDefaultNamespace(null);
    }

    public int getDepth() {
        return this.scopeStack.size();
    }

    public ScopedNamespaceContext copy() {
        return new ScopedNamespaceContext(this.current, (Stack)this.scopeStack.clone());
    }

    public Map getNamespaceMap() {
        return ScopedNamespaceContext.getNamespaceMap(this.current);
    }

    private static final Map getNamespaceMap(LLNamespaceContext lLNamespaceContext) {
        if (lLNamespaceContext == null) {
            return new HashMap();
        }
        Map map = ScopedNamespaceContext.getNamespaceMap(lLNamespaceContext.predecessor);
        map.put(lLNamespaceContext.prefix, lLNamespaceContext.namespace);
        return map;
    }

    private static class LLNamespaceContext {
        private final String prefix;
        private final String namespace;
        private final LLNamespaceContext predecessor;

        public LLNamespaceContext(String string, String string2, LLNamespaceContext lLNamespaceContext) {
            this.prefix = string;
            this.namespace = string2;
            this.predecessor = lLNamespaceContext;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        protected final LLNamespaceContext getPredecessor() {
            return this.predecessor;
        }

        public String getNamespaceURI(String string) {
            LLNamespaceContext lLNamespaceContext = this;
            while (lLNamespaceContext != null) {
                if (string.equals(lLNamespaceContext.prefix)) {
                    return lLNamespaceContext.namespace;
                }
                lLNamespaceContext = lLNamespaceContext.predecessor;
            }
            return null;
        }

        public String getPrefix(String string) {
            LLNamespaceContext lLNamespaceContext = this;
            while (lLNamespaceContext != null) {
                if (string.equals(lLNamespaceContext.namespace)) {
                    return lLNamespaceContext.prefix;
                }
                lLNamespaceContext = lLNamespaceContext.predecessor;
            }
            return null;
        }

        public Iterator getPrefixes(String string) {
            Set set = LLNamespaceContext.getPrefixSet(string, this);
            return set.iterator();
        }

        protected static final Set getPrefixSet(String string, LLNamespaceContext lLNamespaceContext) {
            Stack stack = new Stack(16);
            LLNamespaceContext lLNamespaceContext2 = lLNamespaceContext;
            while (lLNamespaceContext2 != null) {
                stack.push((Object)lLNamespaceContext2);
                lLNamespaceContext2 = lLNamespaceContext2.predecessor;
            }
            ArraySet arraySet = new ArraySet(4);
            while (!stack.isEmpty()) {
                lLNamespaceContext2 = (LLNamespaceContext)stack.pop();
                if (string.equals(lLNamespaceContext2.namespace)) {
                    arraySet.add(lLNamespaceContext2.prefix);
                    continue;
                }
                arraySet.remove(lLNamespaceContext2.prefix);
            }
            return arraySet;
        }
    }
}

