/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.MutableStart;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class StreamUtils {
    private static final String SPACES = "                                                                                                                                            ";
    public static final String PRETTY_PRINT_PROPERTY = "weblogic.xml.security.prettyprint";
    private static boolean PRETTY_PRINT = Boolean.getBoolean(System.getProperty("weblogic.xml.security.prettyprint"));

    public static String space(int n) {
        return SPACES.substring(0, n %= 80);
    }

    public static String getValue(XMLInputStream xMLInputStream, String string, String string2) throws XMLStreamException {
        XMLEvent xMLEvent = StreamUtils.getElement(xMLInputStream, string, string2);
        if (xMLEvent == null) {
            return null;
        }
        xMLEvent = StreamUtils.skipWS(xMLInputStream, false);
        if (!xMLEvent.isCharacterData()) {
            throw new XMLStreamException(string2 + " does not contain text: " + xMLEvent);
        }
        String string3 = ((CharacterData)xMLEvent).getContent();
        xMLEvent = StreamUtils.skipWS(xMLInputStream, false);
        if (!xMLEvent.isEndElement()) {
            throw new XMLStreamException("Malformed " + string2);
        }
        return string3.trim();
    }

    public static String getData(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        XMLEvent xMLEvent = StreamUtils.skipWS(xMLInputStream, false);
        if (!xMLEvent.isCharacterData()) {
            throw new XMLStreamException(string + " does not contain data: " + xMLEvent);
        }
        return ((CharacterData)xMLEvent).getContent().trim();
    }

    public static XMLEvent getElement(XMLInputStream xMLInputStream, String string, String string2) throws XMLStreamException {
        return StreamUtils.element(xMLInputStream, string, string2, false);
    }

    public static boolean peekElement(XMLInputStream xMLInputStream, String string, String string2) throws XMLStreamException {
        return StreamUtils.element(xMLInputStream, string, string2, true) != null;
    }

    public static void closeScope(XMLInputStream xMLInputStream, String string, String string2) throws XMLStreamException {
        boolean bl = xMLInputStream.skip(4);
        if (!bl) {
            throw new XMLStreamException("Found: " + xMLInputStream.peek() + " expected: " + string2);
        }
        XMLEvent xMLEvent = xMLInputStream.next();
        if (!xMLEvent.getName().getLocalName().equals(string2) || !xMLEvent.getName().getNamespaceUri().equals(string)) {
            throw new XMLStreamException("<" + string2 + "> terminated with </" + xMLEvent.getName().getLocalName() + ">");
        }
    }

    public static void closeScope(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        boolean bl = xMLInputStream.skip(4);
        if (!bl) {
            throw new XMLStreamException("Found: " + xMLInputStream.peek() + " expected: " + string);
        }
        XMLEvent xMLEvent = xMLInputStream.next();
        if (!xMLEvent.getName().getLocalName().equals(string)) {
            throw new XMLStreamException("<" + string + "> terminated with </" + xMLEvent.getName().getLocalName() + ">");
        }
    }

    public static Attribute createAttribute(String string, String string2, String string3) {
        if (string3 == null) {
            return null;
        }
        XMLName xMLName = ElementFactory.createXMLName(string, string2);
        return ElementFactory.createAttribute(xMLName, string3);
    }

    public static Attribute createAttribute(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        XMLName xMLName = ElementFactory.createXMLName(string);
        return ElementFactory.createAttribute(xMLName, string2);
    }

    public static XMLEvent peekElement(XMLInputStream xMLInputStream) throws XMLStreamException {
        return StreamUtils.skipWS(xMLInputStream, true);
    }

    public static final boolean matches(XMLEvent xMLEvent, String string, String string2) {
        XMLName xMLName = xMLEvent.getName();
        return xMLName.getLocalName().equals(string) && xMLName.getNamespaceUri().equals(string2);
    }

    public static final boolean matches(XMLEvent xMLEvent, XMLName xMLName) {
        return xMLName.equals(xMLEvent.getName());
    }

    public static final boolean matches(XMLEvent xMLEvent, String string) {
        return xMLEvent.getName().getLocalName().equals(string);
    }

    public static final boolean matchesNamespace(XMLEvent xMLEvent, String string) {
        return xMLEvent.getName().getNamespaceUri().equals(string);
    }

    private static XMLEvent element(XMLInputStream xMLInputStream, String string, String string2, boolean bl) throws XMLStreamException {
        XMLEvent xMLEvent = StreamUtils.skipWS(xMLInputStream, true);
        if (!xMLEvent.isStartElement()) {
            return null;
        }
        if (!xMLEvent.getName().getLocalName().equals(string2) || !xMLEvent.getName().getNamespaceUri().equals(string)) {
            return null;
        }
        if (bl) {
            return xMLEvent;
        }
        return xMLInputStream.next();
    }

    public static void discard(XMLInputStream xMLInputStream) throws XMLStreamException {
        int n = 0;
        boolean bl = true;
        while (n > 0 || bl) {
            bl = false;
            XMLEvent xMLEvent = xMLInputStream.next();
            if (xMLEvent.isStartElement()) {
                ++n;
                continue;
            }
            if (!xMLEvent.isEndElement()) continue;
            --n;
        }
    }

    public static XMLEvent skipWS(XMLInputStream xMLInputStream, boolean bl) throws XMLStreamException {
        XMLEvent xMLEvent = xMLInputStream.peek();
        while (xMLEvent.isSpace() || xMLEvent.isStartPrefixMapping() || xMLEvent.isEndPrefixMapping() || xMLEvent.isChangePrefixMapping()) {
            xMLInputStream.next();
            xMLEvent = xMLInputStream.peek();
        }
        if (bl) {
            return xMLInputStream.peek();
        }
        return xMLInputStream.next();
    }

    public static XMLEvent indent(int n) {
        return ElementFactory.createCharacterData("\n" + StreamUtils.space(n));
    }

    public static void add(XMLOutputStream xMLOutputStream, XMLEvent xMLEvent, int n) throws XMLStreamException {
        if (PRETTY_PRINT) {
            xMLOutputStream.add(StreamUtils.indent(n));
        }
        xMLOutputStream.add(xMLEvent);
    }

    public static void required(Object object, String string, String string2) throws XMLStreamException {
        if (object == null) {
            throw new XMLStreamException("<" + string + "> missing <" + string2 + ">");
        }
    }

    public static void requiredAttr(String string, String string2, String string3) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("<" + string2 + "> missing attribute: " + string3);
        }
    }

    public static String getAttribute(StartElement startElement, String string) {
        XMLName xMLName = ElementFactory.createXMLName(string);
        Attribute attribute = startElement.getAttributeByName(xMLName);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public static void addStart(XMLOutputStream xMLOutputStream, String string, String string2, int n) throws XMLStreamException {
        if (PRETTY_PRINT) {
            xMLOutputStream.add(StreamUtils.indent(n));
        }
        StreamUtils.addStart(xMLOutputStream, string, string2);
    }

    public static void addStart(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        if (PRETTY_PRINT) {
            xMLOutputStream.add(StreamUtils.indent(n));
        }
        StreamUtils.addStart(xMLOutputStream, string);
    }

    public static void addStart(XMLOutputStream xMLOutputStream, String string, String string2) throws XMLStreamException {
        xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement(string, string2));
    }

    public static void addStart(XMLOutputStream xMLOutputStream, String string) throws XMLStreamException {
        xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement(string));
    }

    public static void addStart(XMLOutputStream xMLOutputStream, String string, String string2, Attribute[] attributeArray, int n) throws XMLStreamException {
        if (PRETTY_PRINT) {
            xMLOutputStream.add(StreamUtils.indent(n));
        }
        xMLOutputStream.add((XMLEvent)StreamUtils.createStartElement(string, string2, attributeArray));
    }

    public static void addStart(XMLOutputStream xMLOutputStream, String string, String string2, Attribute[] attributeArray, Attribute[] attributeArray2, int n) throws XMLStreamException {
        MutableStart mutableStart = null;
        mutableStart = StreamUtils.createStartElement(string, string2, attributeArray);
        for (int i = 0; i < attributeArray2.length; ++i) {
            Attribute attribute = attributeArray2[i];
            mutableStart.addNamespace(attribute);
        }
        if (PRETTY_PRINT) {
            xMLOutputStream.add(StreamUtils.indent(n));
        }
        xMLOutputStream.add((XMLEvent)mutableStart);
    }

    private static MutableStart createStartElement(String string, String string2, Attribute[] attributeArray) {
        MutableStart mutableStart = (MutableStart)ElementFactory.createStartElement(string, string2);
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i] == null) continue;
            mutableStart.addAttribute(attributeArray[i]);
        }
        return mutableStart;
    }

    public static void addStart(XMLOutputStream xMLOutputStream, String string, String string2, Attribute[] attributeArray) throws XMLStreamException {
        MutableStart mutableStart = (MutableStart)ElementFactory.createStartElement(string, string2);
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i] == null) continue;
            mutableStart.addAttribute(attributeArray[i]);
        }
        xMLOutputStream.add((XMLEvent)mutableStart);
    }

    public static void addStart(XMLOutputStream xMLOutputStream, String string, Attribute[] attributeArray) throws XMLStreamException {
        MutableStart mutableStart = (MutableStart)ElementFactory.createStartElement(string);
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i] == null) continue;
            mutableStart.addAttribute(attributeArray[i]);
        }
        xMLOutputStream.add((XMLEvent)mutableStart);
    }

    public static void addStart(XMLOutputStream xMLOutputStream, String string, Attribute[] attributeArray, int n) throws XMLStreamException {
        if (PRETTY_PRINT) {
            xMLOutputStream.add(StreamUtils.indent(n));
        }
        StreamUtils.addStart(xMLOutputStream, string, attributeArray);
    }

    public static void addEnd(XMLOutputStream xMLOutputStream, String string, String string2, int n) throws XMLStreamException {
        if (PRETTY_PRINT) {
            xMLOutputStream.add(StreamUtils.indent(n));
        }
        StreamUtils.addEnd(xMLOutputStream, string, string2);
    }

    public static void addEnd(XMLOutputStream xMLOutputStream, String string, String string2) throws XMLStreamException {
        xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement(string, string2));
    }

    public static void addEnd(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        if (PRETTY_PRINT) {
            xMLOutputStream.add(StreamUtils.indent(n));
        }
        xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement(string));
    }

    public static void addEnd(XMLOutputStream xMLOutputStream, String string) throws XMLStreamException {
        xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement(string));
    }

    public static void addEmptyElement(XMLOutputStream xMLOutputStream, String string, Attribute[] attributeArray, int n) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, attributeArray, n);
        xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement(string));
    }

    public static void addElement(XMLOutputStream xMLOutputStream, String string, String string2, String string3, int n, int n2) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, string2, n);
        if (string3 != null) {
            StreamUtils.addText(xMLOutputStream, string3, n + n2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, string2, n);
    }

    public static void addElement(XMLOutputStream xMLOutputStream, String string, String string2, String string3, Attribute[] attributeArray, int n, int n2) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, string2, attributeArray, n);
        if (string3 != null) {
            StreamUtils.addText(xMLOutputStream, string3, n + n2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, string2, n);
    }

    public static void addElement(XMLOutputStream xMLOutputStream, String string, String string2, Attribute[] attributeArray, int n, int n2) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, attributeArray, n);
        if (string2 != null) {
            StreamUtils.addText(xMLOutputStream, string2, n + n2);
        }
        StreamUtils.addEnd(xMLOutputStream, string, n);
    }

    public static void addElement(XMLOutputStream xMLOutputStream, String string, String string2, String string3, int n) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, string2, n);
        StreamUtils.addText(xMLOutputStream, string3, n + 2);
        StreamUtils.addEnd(xMLOutputStream, string, string2, n);
    }

    public static void addElement(XMLOutputStream xMLOutputStream, String string, String string2, int n) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, n);
        xMLOutputStream.add(ElementFactory.createCharacterData(string2));
        xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement(string));
    }

    public static void addElement(XMLOutputStream xMLOutputStream, String string, String string2, int n, int n2) throws XMLStreamException {
        StreamUtils.addStart(xMLOutputStream, string, n);
        StreamUtils.addText(xMLOutputStream, string2, n + n2);
        StreamUtils.addEnd(xMLOutputStream, string, n);
    }

    public static void addText(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        StreamUtils.add(xMLOutputStream, ElementFactory.createCharacterData(string), n);
    }

    public static String getAttributeByName(String string, String string2, StartElement startElement) {
        AttributeIterator attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            String string3;
            Attribute attribute = attributeIterator.next();
            XMLName xMLName = attribute.getName();
            if (!string.equals(xMLName.getLocalName()) || !((string3 = xMLName.getNamespaceUri()) != null ? string3.equals(string2) : string2 == null)) continue;
            return attribute.getValue();
        }
        return null;
    }
}

