/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.Map;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.MutableStart;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.Preprocessor;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class TaggingPreprocessor
implements Preprocessor {
    private static final String[] WSU_DECL = new String[]{WSUConstants.WSU_URI, "wsu"};
    private static final String[] DSIG_DECL = new String[]{"http://www.w3.org/2000/09/xmldsig#", "dsig"};
    private static final String[] XENC_DECL = new String[]{"http://www.w3.org/2001/04/xmlenc#", "xenc"};
    private static final String[][] ID_NAMESPACES = new String[][]{DSIG_DECL, XENC_DECL};

    public final void begin(StartElement startElement, XMLOutputStream xMLOutputStream) throws XMLStreamException {
        StartElement startElement2;
        String[] stringArray = TaggingPreprocessor.getIdNamespace(startElement);
        String string = TaggingPreprocessor.getIdAttribute(startElement, TaggingPreprocessor.getNamespace(stringArray));
        if (string != null) {
            startElement2 = startElement;
        } else {
            Map map;
            MutableStart mutableStart;
            string = Utils.generateId(startElement.getName().getLocalName());
            if (startElement instanceof MutableStart) {
                mutableStart = (MutableStart)startElement;
                startElement2 = mutableStart;
            } else {
                mutableStart = new MutableStart(startElement);
                startElement2 = mutableStart;
                mutableStart.markNamespaced();
            }
            String string2 = null;
            if (xMLOutputStream instanceof NSOutputStream) {
                map = ((NSOutputStream)xMLOutputStream).getNamespaces();
                string2 = (String)map.get(TaggingPreprocessor.getNamespace(stringArray));
            }
            if (string2 == null) {
                string2 = TaggingPreprocessor.getPrefix(stringArray);
            }
            map = ElementFactory.createXMLName(TaggingPreprocessor.getNamespace(stringArray), "Id", string2);
            mutableStart.addAttribute(ElementFactory.createAttribute((XMLName)map, string));
        }
        this.begin(startElement2, xMLOutputStream, string);
    }

    private static final String getIdAttribute(StartElement startElement, String string) {
        String string2 = StreamUtils.getAttributeByName("Id", string, startElement);
        return string2;
    }

    protected abstract void begin(StartElement var1, XMLOutputStream var2, String var3) throws XMLStreamException;

    public abstract void end(EndElement var1, XMLOutputStream var2) throws XMLStreamException;

    private static String[] getIdNamespace(StartElement startElement) {
        XMLName xMLName = startElement.getName();
        String string = xMLName.getNamespaceUri();
        for (int i = 0; i < ID_NAMESPACES.length; ++i) {
            String[] stringArray = ID_NAMESPACES[i];
            if (!TaggingPreprocessor.getNamespace(stringArray).equals(string)) continue;
            return stringArray;
        }
        return WSU_DECL;
    }

    private static String getNamespace(String[] stringArray) {
        return stringArray[0];
    }

    private static String getPrefix(String[] stringArray) {
        return stringArray[1];
    }
}

