/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.xml.security.signature.DSIGConstants;
import weblogic.xml.stream.XMLName;
import weblogic.xml.util.WhitespaceUtils;

public class Utils {
    private static final int DEFAULT_NONCE_SIZE = 20;
    private static int DEFAULT_ID_SIZE = 18;
    private static final String SUBJECT_KEY_IDENTIFIER_OID = "2.5.29.14";
    private static CertificateFactory certFactory;
    private static SecureRandom rng;
    private static String UTF_8;
    private static final String SECURE_RANDOM = "SecureRandom";
    private static final String SUN_RNG_TYPE = "SHA1PRNG";
    private static final String IBM_RNG_TYPE = "IBMSecureRandom";
    public static final String ENCODING_PKIPATH = "PkiPath";
    public static final String ENCODING_PKCS7 = "PKCS7";

    public static String toCryptoBinary(BigInteger bigInteger) {
        if (bigInteger == null) {
            return null;
        }
        byte[] byArray = bigInteger.toByteArray();
        int n = 0;
        for (int i = 0; i < byArray.length && byArray[i] == 0; ++i) {
            ++n;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encodeBuffer(byArray2);
    }

    public static BigInteger fromCryptoBinary(String string) {
        string = WhitespaceUtils.removeAllWhitespaces(string);
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = null;
        try {
            byArray = bASE64Decoder.decodeBuffer(string);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return new BigInteger(1, byArray);
    }

    public static String base64(byte[] byArray) {
        return new BASE64Encoder().encodeBuffer(byArray);
    }

    public static byte[] base64(String string) {
        string = WhitespaceUtils.removeAllWhitespaces(string);
        try {
            return new BASE64Decoder().decodeBuffer(string);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static String toBase64(byte[] byArray) {
        return new BASE64Encoder().encodeBuffer(byArray);
    }

    public static String toBase64(X509Certificate x509Certificate) throws CertificateException {
        return Utils.toBase64(x509Certificate.getEncoded());
    }

    public static CertificateFactory getCertFactory() {
        if (certFactory == null) {
            try {
                certFactory = CertificateFactory.getInstance("X.509");
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }
        return certFactory;
    }

    public static X509Certificate certFromBase64(String string) throws CertificateException {
        byte[] byArray = Utils.base64(string);
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
        return (X509Certificate)Utils.getCertFactory().generateCertificate((InputStream)unsyncByteArrayInputStream);
    }

    public static SecureRandom getRNG() {
        if (rng == null) {
            SecureRandom secureRandom;
            block6: {
                try {
                    Set<String> set = Security.getAlgorithms(SECURE_RANDOM);
                    if (set.contains(SUN_RNG_TYPE)) {
                        secureRandom = SecureRandom.getInstance(SUN_RNG_TYPE);
                        break block6;
                    }
                    if (set.contains(IBM_RNG_TYPE)) {
                        secureRandom = SecureRandom.getInstance(IBM_RNG_TYPE);
                        break block6;
                    }
                    if (!set.isEmpty()) {
                        secureRandom = SecureRandom.getInstance(set.iterator().next());
                        break block6;
                    }
                    throw new AssertionError((Object)"No SecureRandom provider available");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new AssertionError((Object)noSuchAlgorithmException);
                }
            }
            rng = secureRandom;
        }
        return rng;
    }

    public static String generateNonce() {
        return Utils.generateBase64Nonce(20);
    }

    public static byte[] passwordDigest(String string, String string2, String string3) throws NoSuchAlgorithmException {
        return Utils.passwordDigest(Utils.base64(string), string2, string3);
    }

    public static byte[] passwordDigest(byte[] byArray, String string, String string2) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(byArray);
        try {
            messageDigest.update(string.getBytes(UTF_8));
            messageDigest.update(string2.getBytes(UTF_8));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)("Unable to create password digest - UTF-8 encoding required but unavailable: " + unsupportedEncodingException.getMessage()));
        }
        byte[] byArray2 = messageDigest.digest();
        return byArray2;
    }

    public static String generateBase64Nonce(int n) {
        byte[] byArray = Utils.generateNonce(n);
        return new BASE64Encoder().encodeBuffer(byArray);
    }

    public static String generateXPointerId(int n) {
        String string = Utils.generateBase64Nonce(n);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '=' || c == '+' || c == '/') {
                c = '_';
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static byte[] generateNonce(int n) {
        byte[] byArray = new byte[n];
        Utils.getRNG().nextBytes(byArray);
        return byArray;
    }

    public static String generateId() {
        return Utils.generateId("Unknown");
    }

    public static String generateId(String string) {
        return Utils.generateId(string, DEFAULT_ID_SIZE);
    }

    public static String generateId(String string, int n) {
        if (!DSIGConstants.VERBOSE) {
            string = "Id";
        }
        return string + "-" + Utils.generateXPointerId(n);
    }

    public static final byte[] getSubjectKeyIdentifier(X509Certificate x509Certificate) {
        byte[] byArray;
        byte[] byArray2 = x509Certificate.getExtensionValue(SUBJECT_KEY_IDENTIFIER_OID);
        if (byArray2 != null) {
            int n = Utils.getSkidContentLength(byArray2);
            int n2 = byArray2.length - n;
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = byArray2[i + n2];
            }
        } else {
            byArray = null;
        }
        return byArray;
    }

    private static final int getSkidContentLength(byte[] byArray) {
        return byArray.length - 4;
    }

    public static final QName getQName(XMLName xMLName) {
        return new QName(xMLName.getNamespaceUri(), xMLName.getLocalName());
    }

    public static CertPath generateCertPath(X509Certificate[] x509CertificateArray) {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            X509Certificate x509Certificate = x509CertificateArray[i];
            arrayList.add(x509Certificate);
        }
        return Utils.generateCertPath(arrayList);
    }

    public static CertPath generateCertPath(List list) {
        CertPath certPath;
        try {
            certPath = Utils.getCertFactory().generateCertPath(list);
        }
        catch (CertificateException certificateException) {
            throw new IllegalArgumentException("Unable to create CertPath from certificates: " + certificateException);
        }
        return certPath;
    }

    static {
        UTF_8 = "UTF-8";
    }
}

