/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.NoSuchElementException;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class XMLEventBuffer {
    private static final int INITIAL_BUFFER_SIZE = 256;
    private int initialSize = 256;
    private int bufferSize;
    private int nextWrite;
    private int nextRead;
    private int bufferCount;
    private XMLEvent[] buffer;

    public XMLEventBuffer() {
        this.initialSize = 256;
    }

    public XMLEventBuffer(int n) {
        this.initialSize = n;
    }

    public void add(XMLEvent xMLEvent) {
        if (this.buffer == null) {
            this.init(this.initialSize);
        }
        if (this.bufferCount == this.bufferSize) {
            this.expand();
        }
        this.buffer[this.nextWrite] = xMLEvent;
        this.eventWritten();
    }

    private void init(int n) {
        this.bufferSize = n;
        this.buffer = new XMLEvent[this.bufferSize];
        this.bufferCount = 0;
        this.nextRead = 0;
        this.nextWrite = 0;
    }

    public XMLEvent peek() {
        if (this.hasNext()) {
            return this.buffer[this.nextRead];
        }
        throw new NoSuchElementException("buffer is empty");
    }

    public boolean hasNext() {
        return this.bufferCount > 0;
    }

    public XMLEvent next() {
        if (this.hasNext()) {
            XMLEvent xMLEvent = this.buffer[this.nextRead];
            this.buffer[this.nextRead] = null;
            this.eventRead();
            return xMLEvent;
        }
        throw new NoSuchElementException("buffer is empty");
    }

    public void process(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        while (this.hasNext()) {
            xMLOutputStream.add(this.next());
        }
    }

    private void eventWritten() {
        ++this.bufferCount;
        ++this.nextWrite;
        if (this.nextWrite == this.bufferSize) {
            this.nextWrite = 0;
        }
    }

    private void eventRead() {
        --this.bufferCount;
        ++this.nextRead;
        if (this.nextRead == this.bufferSize) {
            this.nextRead = 0;
        }
        if (this.bufferCount < 1) {
            this.collapse();
        }
    }

    private void collapse() {
        this.buffer = null;
        this.bufferCount = 0;
        this.bufferSize = 0;
        this.nextRead = 0;
        this.nextWrite = 0;
    }

    private void expand() {
        XMLEvent[] xMLEventArray = new XMLEvent[this.bufferSize * 2];
        int n = this.nextRead;
        for (int i = 0; i < this.bufferSize; ++i) {
            if (n == this.bufferSize) {
                n = 0;
            }
            xMLEventArray[i] = this.buffer[n];
            ++n;
        }
        this.nextRead = 0;
        this.nextWrite = this.bufferSize;
        this.bufferSize = 2 * this.bufferSize;
        this.buffer = xMLEventArray;
    }
}

