/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import weblogic.xml.babel.stream.XMLInputStreamFactoryImpl;
import weblogic.xml.stream.BufferedXMLInputStream;
import weblogic.xml.stream.ReferenceResolver;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public abstract class XMLInputStreamBase
implements XMLInputStream {
    protected static final XMLInputStreamFactory factory = new XMLInputStreamFactoryImpl();
    protected XMLInputStream source;

    protected XMLInputStreamBase(XMLInputStream xMLInputStream) {
        this.source = xMLInputStream;
    }

    protected XMLInputStreamBase() {
    }

    public abstract XMLEvent next() throws XMLStreamException;

    public boolean hasNext() throws XMLStreamException {
        return this.source.hasNext();
    }

    public final void skip() throws XMLStreamException {
        this.next();
    }

    public final void skipElement() throws XMLStreamException {
        int n = 0;
        boolean bl = false;
        while (this.hasNext() && !bl) {
            XMLEvent xMLEvent = this.next();
            switch (xMLEvent.getType()) {
                case 2: {
                    ++n;
                    break;
                }
                case 4: {
                    if (--n > 0) break;
                    bl = true;
                    break;
                }
                case 128: 
                case 512: {
                    bl = true;
                }
            }
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        return this.source.peek();
    }

    public final boolean skip(int n) throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent xMLEvent = this.peek();
            if (xMLEvent == null) {
                return false;
            }
            if (xMLEvent.getType() == 128) {
                return false;
            }
            if ((xMLEvent.getType() & n) != 0) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public final boolean skip(XMLName xMLName) throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent xMLEvent = this.peek();
            switch (xMLEvent.getType()) {
                case 2: 
                case 4: {
                    if (!xMLName.equals(xMLEvent.getName())) break;
                    return true;
                }
            }
            this.next();
        }
        return false;
    }

    public final boolean skip(XMLName xMLName, int n) throws XMLStreamException {
        while (this.skip(xMLName)) {
            XMLEvent xMLEvent = this.peek();
            if ((xMLEvent.getType() & n) != 0) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public XMLInputStream getSubStream() throws XMLStreamException {
        if (!(this.source instanceof BufferedXMLInputStream)) {
            this.source = factory.newBufferedInputStream(this.source);
        }
        return this.source.getSubStream();
    }

    public final void close() throws XMLStreamException {
        this.source.close();
    }

    public final ReferenceResolver getReferenceResolver() {
        return this.source.getReferenceResolver();
    }

    public final void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.source.setReferenceResolver(referenceResolver);
    }
}

