/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.HashMap;
import java.util.Map;
import weblogic.utils.collections.Stack;
import weblogic.xml.security.utils.AbstractXMLReader;
import weblogic.xml.security.utils.ValidationException;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.util.TypeFilter;

public class XMLInputStreamReader
extends AbstractXMLReader {
    private static TypeFilter filter = new TypeFilter(22);
    private static XMLInputStreamFactory streamFactory = XMLInputStreamFactory.newInstance();
    private final Stack startStack = new Stack();
    private final XMLInputStream source;
    private XMLEvent current;
    private StartElement currentStart = null;
    private boolean endReached;
    private int currentType = 0;

    public XMLInputStreamReader(XMLInputStream xMLInputStream) throws XMLStreamException {
        this.source = streamFactory.newInputStream(xMLInputStream, (ElementFilter)filter);
        this.endReached = false;
        this.next();
    }

    public int next() {
        try {
            if (this.endReached || !this.source.hasNext()) {
                this.endReached = true;
                return 0;
            }
            XMLEvent xMLEvent = this.source.next();
            switch (xMLEvent.getType()) {
                case 2: {
                    return this.process((StartElement)xMLEvent);
                }
                case 4: {
                    return this.process((EndElement)xMLEvent);
                }
                case 16: {
                    return this.process((CharacterData)xMLEvent);
                }
            }
            throw new AssertionError((Object)("received " + xMLEvent + "; should have been filtered"));
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException("problem parsing document", xMLStreamException);
        }
    }

    private int process(StartElement startElement) {
        this.startStack.push((Object)this.currentStart);
        this.currentStart = startElement;
        this.current = this.currentStart;
        this.currentType = 2;
        return 2;
    }

    private int process(EndElement endElement) throws XMLStreamException {
        if (this.startStack.isEmpty()) {
            throw new XMLStreamException("End tag without corresponding start");
        }
        this.current = endElement;
        this.currentStart = (StartElement)this.startStack.pop();
        if (this.startStack.isEmpty()) {
            this.endReached = true;
        }
        this.currentType = 4;
        return 4;
    }

    private int process(CharacterData characterData) {
        this.current = characterData;
        this.currentType = 16;
        return 16;
    }

    public boolean hasName() {
        return this.currentType == 2 || this.currentType == 4;
    }

    public String getNamespaceURI() throws IllegalStateException {
        if (!this.hasName()) {
            throw new IllegalStateException("Current node has no name");
        }
        return this.current.getName().getNamespaceUri();
    }

    public String getLocalName() throws IllegalStateException {
        if (!this.hasName()) {
            throw new IllegalStateException("Current node has no name");
        }
        return this.current.getName().getLocalName();
    }

    public void require(int n, String string, String string2) throws ValidationException {
        switch (n) {
            case 16: {
                if (this.currentType == 16) {
                    return;
                }
                throw new ValidationException("received " + this.current + " instead of expected " + "character data");
            }
            case 2: {
                if (this.currentType != 2) {
                    throw new ValidationException("expected start element " + string + ":" + string2 + ", received " + this.current);
                }
                XMLName xMLName = this.current.getName();
                if (!xMLName.getLocalName().equals(string2) || string != null && !string.equals(xMLName.getNamespaceUri())) {
                    throw new ValidationException("exptected <" + string + ":" + string2 + ">, got " + this.current);
                }
                return;
            }
            case 4: {
                if (this.currentType != 4) {
                    throw new ValidationException("expected start element " + string + ":" + string2 + ", received " + this.current);
                }
                XMLName xMLName = this.current.getName();
                if (!xMLName.getLocalName().equals(string2) || string != null && !string.equals(xMLName.getNamespaceUri())) {
                    throw new ValidationException("exptected </" + string + ":" + string2 + ">, got " + this.current);
                }
                return;
            }
        }
        throw new IllegalArgumentException("unknown type");
    }

    public void close() {
        this.startStack.clear();
        this.current = null;
        this.currentStart = null;
        this.endReached = true;
    }

    public int getEventType() {
        return this.currentType;
    }

    public boolean isStartElement() {
        return this.currentType == 2;
    }

    public boolean isEndElement() {
        return this.currentType == 4;
    }

    public boolean isCharacters() {
        return this.currentType == 16;
    }

    public String getAttribute(String string, String string2) throws IllegalStateException {
        if (this.currentType != 2) {
            throw new IllegalStateException("current event is not a start event");
        }
        Attribute attribute = this.currentStart.getAttributeByName((XMLName)new Name(string, string2, null));
        return attribute != null ? attribute.getValue() : null;
    }

    public String getNamespaceURI(String string) {
        return null;
    }

    public Map getNamespaceMap() {
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.currentStart.getNamespaceMap());
        return hashMap;
    }

    public String getText() throws IllegalStateException {
        if (this.currentType != 16) {
            throw new IllegalStateException("expected CDATA, got " + this.current);
        }
        return ((CharacterData)this.current).getContent();
    }
}

