/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public abstract class XMLObjectReader {
    private ConcurrentHashMap types = new ConcurrentHashMap();

    public Object readObject(XMLInputStream xMLInputStream) throws XMLStreamException {
        XMLName xMLName = this.getNextName(xMLInputStream);
        if (xMLName == null) {
            return null;
        }
        Integer n = (Integer)this.types.get((Object)xMLName);
        if (n == null) {
            return null;
        }
        return this.readObjectInternal(n, xMLName.getNamespaceUri(), xMLInputStream);
    }

    public Object readObject(XMLInputStream xMLInputStream, int n) throws XMLStreamException {
        XMLName xMLName = this.getNextName(xMLInputStream);
        if (xMLName == null) {
            return null;
        }
        Integer n2 = (Integer)this.types.get((Object)xMLName);
        if (n2 == null) {
            return null;
        }
        if (n2 != n) {
            return null;
        }
        return this.readObjectInternal(n2, xMLName.getNamespaceUri(), xMLInputStream);
    }

    private XMLName getNextName(XMLInputStream xMLInputStream) throws XMLStreamException {
        XMLEvent xMLEvent = StreamUtils.peekElement(xMLInputStream);
        if (xMLEvent == null || !xMLEvent.isStartElement()) {
            return null;
        }
        return xMLEvent.getName();
    }

    public abstract Object readObjectInternal(int var1, String var2, XMLInputStream var3) throws XMLStreamException;

    protected void register(String string, String string2, int n) {
        XMLName xMLName = ElementFactory.createXMLName(string, string2);
        this.types.put((Object)xMLName, (Object)new Integer(n));
    }
}

