/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import weblogic.xml.babel.stream.XMLInputStreamFactoryImpl;
import weblogic.xml.security.utils.MutableStart;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.util.TypeFilter;

public abstract class XMLOutputStreamBase
implements NSOutputStream {
    protected NSOutputStream dest;
    private StartElement lastStart;
    private MutableStart mutableElement;
    private static final String XMLNS = "xmlns";

    protected XMLOutputStreamBase() {
        this.dest = null;
    }

    protected XMLOutputStreamBase(XMLOutputStream xMLOutputStream) {
        this.setDestination(xMLOutputStream);
    }

    protected void setDestination(XMLOutputStream xMLOutputStream) {
        this.dest = xMLOutputStream instanceof NSOutputStream ? (NSOutputStream)xMLOutputStream : new NamespaceAwareXOS(xMLOutputStream);
    }

    protected abstract void addXMLEvent(XMLEvent var1) throws XMLStreamException;

    public final void add(XMLEvent xMLEvent) throws XMLStreamException {
        if (this.lastStart != null) {
            this.addXMLEvent((XMLEvent)this.lastStart);
            this.clearLastStart();
        }
        if (xMLEvent.isStartElement()) {
            this.setLastStart((StartElement)xMLEvent);
        } else {
            this.addXMLEvent(xMLEvent);
        }
    }

    protected void setLastStart(StartElement startElement) {
        this.lastStart = startElement;
        this.mutableElement = null;
    }

    protected void clearLastStart() {
        this.lastStart = null;
        this.mutableElement = null;
    }

    public void add(XMLInputStream xMLInputStream) throws XMLStreamException {
        while (xMLInputStream.hasNext()) {
            this.add(xMLInputStream.next());
        }
    }

    public void add(String string) throws XMLStreamException {
        new XMLInputStreamFactoryImpl();
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactoryImpl.newInstance();
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newInputStream((Reader)new StringReader(string), (ElementFilter)new TypeFilter(8318));
        this.add(xMLInputStream);
    }

    public final void add(Attribute attribute) throws XMLStreamException {
        if (this.lastStart == null) {
            throw new XMLStreamException("Cannot add attribute: Last event was not a StartEvent");
        }
        if (this.mutableElement == null) {
            this.mutableElement = new MutableStart(this.lastStart);
            this.lastStart = this.mutableElement;
        }
        XMLName xMLName = attribute.getName();
        String string = xMLName.getPrefix();
        String string2 = xMLName.getLocalName();
        if (XMLNS.equals(string) || string == null && XMLNS.equals(string2)) {
            this.mutableElement.addNamespace(attribute);
        } else {
            this.mutableElement.addAttribute(attribute);
        }
    }

    public void close() throws XMLStreamException {
        this.close(true);
    }

    public void close(boolean bl) throws XMLStreamException {
        if (this.lastStart != null) {
            this.dest.add((XMLEvent)this.lastStart);
        }
        this.clearLastStart();
        this.dest.close(bl);
    }

    public void flush() throws XMLStreamException {
        if (this.lastStart != null) {
            this.dest.add((XMLEvent)this.lastStart);
        }
        this.clearLastStart();
        this.dest.flush();
    }

    public void addPrefix(String string, String string2) {
        this.dest.addPrefix(string, string2);
    }

    public Map getNamespaces() {
        return this.dest.getNamespaces();
    }
}

