/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.Map;
import java.util.Set;
import weblogic.utils.collections.Stack;
import weblogic.xml.security.utils.AbstractXMLWriter;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.XMLWriterRuntimeException;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.AttributeImpl;
import weblogic.xml.stream.events.CharacterDataEvent;
import weblogic.xml.stream.events.EndElementEvent;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.events.StartElementEvent;

public class XMLOutputStreamWriter
extends AbstractXMLWriter {
    private String ATTR_TYPE = "CDATA";
    private final XMLOutputStream destination;
    private final Stack nameStack = new Stack();
    private StartElementEvent start = null;

    public XMLOutputStreamWriter(XMLOutputStream xMLOutputStream) {
        this.destination = xMLOutputStream;
    }

    public XMLOutputStreamWriter(NSOutputStream nSOutputStream) {
        this((XMLOutputStream)nSOutputStream);
        Map map = nSOutputStream.getNamespaces();
        this.openScope();
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            this.addNamespacePrefix((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void writeStartElement(String string, String string2) {
        Name name;
        if (this.start != null) {
            this.writeStart();
        }
        this.openScope();
        if (string == null) {
            name = new Name(null, string2, null);
            this.start = new StartElementEvent((XMLName)name);
        } else {
            String string3 = this.findPrefix(string);
            if (string3 == null) {
                string3 = this.generatePrefix(string);
                name = new Name(string, string2, string3);
                this.start = new StartElementEvent((XMLName)name);
                this.bindNamespace(string3, string);
            } else {
                name = new Name(string, string2, string3);
                this.start = new StartElementEvent((XMLName)name);
            }
        }
        this.nameStack.push((Object)name);
    }

    public void writeAttribute(String string, String string2, String string3) throws IllegalStateException {
        Name name;
        if (this.start == null) {
            throw new IllegalStateException("Attributes can only be written immediately after start");
        }
        if (string != null) {
            String string4 = this.findOrBindNamespace(string);
            name = new Name(string, string2, string4);
        } else {
            name = new Name(string, string2);
        }
        this.start.addAttribute((Attribute)new AttributeImpl((XMLName)name, string3, this.ATTR_TYPE));
    }

    public void writeCharacters(String string) throws XMLWriterRuntimeException {
        try {
            if (this.start != null) {
                this.writeStart();
            }
            CharacterDataEvent characterDataEvent = new CharacterDataEvent(string);
            this.destination.add((XMLEvent)characterDataEvent);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLWriterRuntimeException(xMLStreamException);
        }
    }

    private void writeStart() {
        if (this.start != null) {
            try {
                this.destination.add((XMLEvent)this.start);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new XMLWriterRuntimeException(xMLStreamException);
            }
            this.start = null;
        }
    }

    public void writeEndElement() throws XMLWriterRuntimeException {
        try {
            if (this.start != null) {
                this.writeStart();
            }
            if (this.nameStack.isEmpty()) {
                throw new XMLWriterRuntimeException("Unmatched End element");
            }
            Name name = (Name)this.nameStack.pop();
            EndElementEvent endElementEvent = new EndElementEvent((XMLName)name);
            this.destination.add((XMLEvent)endElementEvent);
            this.closeScope();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLWriterRuntimeException(xMLStreamException);
        }
    }

    public void flush() {
        this.writeStart();
    }

    public void close() {
        this.flush();
        try {
            this.destination.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLWriterRuntimeException(xMLStreamException);
        }
    }

    protected void bindNamespace(String string, String string2) {
        if (this.start == null) {
            throw new IllegalStateException("namespace declaration required but start tag has already been written");
        }
        this.start.addNamespace(ElementFactory.createNamespaceAttribute(string, string2));
        this.addNamespacePrefix(string, string2);
    }

    protected void bindDefaultNamespace(String string) {
        if (this.start == null) {
            throw new IllegalStateException("namespace declaration required but start tag has already been written");
        }
        this.start.addNamespace(ElementFactory.createNamespaceAttribute("", string));
        this.addDefaultNamespace(string);
    }
}

