/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import javax.xml.soap.SOAPElement;
import org.w3c.dom.Node;
import weblogic.xml.babel.stream.DOMInputStream;
import weblogic.xml.security.utils.SOAPElementReader;
import weblogic.xml.security.utils.XMLInputStreamReader;
import weblogic.xml.security.utils.XMLReader;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class XMLReaderFactory {
    private static final XMLReaderFactory theOne = new XMLReaderFactory();

    public static XMLReaderFactory getInstance() {
        return theOne;
    }

    public XMLReader createXMLReader(SOAPElement sOAPElement) {
        return new SOAPElementReader(sOAPElement);
    }

    public XMLReader createXMLReader(XMLInputStream xMLInputStream) {
        try {
            return new XMLInputStreamReader(xMLInputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RuntimeException("problem with stream", xMLStreamException);
        }
    }

    public XMLReader createXMLReader(Node node) {
        DOMInputStream dOMInputStream = new DOMInputStream();
        try {
            dOMInputStream.open(node);
            return this.createXMLReader((XMLInputStream)dOMInputStream);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IllegalArgumentException("unable to parse node");
        }
    }
}

