/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import javax.xml.soap.SOAPElement;
import weblogic.xml.security.utils.ValidationException;
import weblogic.xml.security.utils.XMLReader;
import weblogic.xml.security.utils.XMLReaderFactory;
import weblogic.xml.security.utils.XMLWriter;
import weblogic.xml.security.utils.XMLWriterFactory;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class XMLSerializable {
    private static final XMLReaderFactory rFactory = XMLReaderFactory.getInstance();
    private static final XMLWriterFactory wFactory = XMLWriterFactory.getInstance();

    public abstract void toXML(XMLWriter var1);

    public void toXML(XMLOutputStream xMLOutputStream) {
        this.toXML(wFactory.createXMLWriter(xMLOutputStream));
    }

    public void toXML(SOAPElement sOAPElement) {
        this.toXML(wFactory.createXMLWriter(sOAPElement));
    }

    protected abstract void fromXMLInternal(XMLReader var1) throws ValidationException;

    protected void fromXMLInternal(XMLInputStream xMLInputStream) throws XMLStreamException {
        try {
            this.fromXMLInternal(rFactory.createXMLReader(xMLInputStream));
        }
        catch (ValidationException validationException) {
            throw new XMLStreamException((Throwable)((Object)validationException));
        }
    }

    protected void fromXMLInternal(SOAPElement sOAPElement) {
        try {
            this.fromXMLInternal(rFactory.createXMLReader(sOAPElement));
        }
        catch (ValidationException validationException) {
            throw new RuntimeException((Throwable)((Object)validationException));
        }
    }

    protected static final int skip(XMLReader xMLReader) throws ValidationException {
        int n = 0;
        int n2 = xMLReader.getEventType();
        if (n2 == 4) {
            return n2;
        }
        do {
            switch (n2) {
                case 2: {
                    ++n;
                    break;
                }
                case 4: {
                    --n;
                    break;
                }
                case 16: {
                    break;
                }
                default: {
                    throw new ValidationException("unexpected event");
                }
            }
            n2 = xMLReader.next();
        } while (n > 0);
        return n2;
    }
}

