/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.xml.security.utils.Observer;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public class XMLStreamObserver {
    private static final String ATTR_ID = "Id";
    private final List idNamespaces;
    private final Map eventRegistrations = new HashMap();
    private final Map idRegistrations = new HashMap();
    private LLNode activeObservers = null;
    private int totalRegistrations = 0;

    public XMLStreamObserver() {
        this.idNamespaces = new ArrayList();
        this.idNamespaces.add(null);
    }

    public XMLStreamObserver(String string) {
        this();
        this.idNamespaces.add(string);
    }

    public XMLStreamObserver(String[] stringArray) {
        this();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.idNamespaces.add(string);
        }
    }

    public void add(XMLEvent xMLEvent, Observer observer) {
        LLNode lLNode = new LLNode(observer);
        LLNode lLNode2 = this.eventRegistrations.put(xMLEvent, lLNode);
        lLNode.next = lLNode2;
        ++this.totalRegistrations;
    }

    public void add(String string, Observer observer) {
        LLNode lLNode = new LLNode(observer);
        LLNode lLNode2 = this.idRegistrations.put(string, lLNode);
        lLNode.next = lLNode2;
        ++this.totalRegistrations;
    }

    public boolean observe(XMLEvent xMLEvent) throws XMLStreamException {
        block2: {
            block3: {
                if (this.totalRegistrations == 0 || !xMLEvent.isStartElement()) break block2;
                if (this.eventRegistrations.isEmpty()) break block3;
                LLNode lLNode = (LLNode)this.eventRegistrations.remove(xMLEvent);
                if (lLNode == null) break block2;
                this.addObservers(lLNode);
                break block2;
            }
            if (!this.idRegistrations.isEmpty()) {
                StartElement startElement = (StartElement)xMLEvent;
                AttributeIterator attributeIterator = startElement.getAttributes();
                while (attributeIterator.hasNext()) {
                    String string;
                    Attribute attribute = attributeIterator.next();
                    XMLName xMLName = attribute.getName();
                    String string2 = xMLName.getLocalName();
                    if (!ATTR_ID.equals(string2) || !this.idNamespaces.contains(string = xMLName.getNamespaceUri())) continue;
                    String string3 = attribute.getValue();
                    LLNode lLNode = (LLNode)this.idRegistrations.remove("#" + string3);
                    if (lLNode == null) continue;
                    this.addObservers(lLNode);
                    if (!this.idRegistrations.isEmpty()) continue;
                    break;
                }
            }
        }
        return this.notifyObservers(xMLEvent);
    }

    private boolean notifyObservers(XMLEvent xMLEvent) throws XMLStreamException {
        if (this.activeObservers == null) {
            return false;
        }
        boolean bl = false;
        LLNode lLNode = this.activeObservers;
        LLNode lLNode2 = null;
        while (lLNode != null) {
            Observer observer = lLNode.observer;
            if (observer.consumes()) {
                bl = true;
            }
            if (!observer.observe(xMLEvent)) {
                if (lLNode2 == null) {
                    this.activeObservers = lLNode.next;
                } else {
                    lLNode2.next = lLNode.next;
                }
                --this.totalRegistrations;
            } else {
                lLNode2 = lLNode;
            }
            lLNode = lLNode.next;
        }
        return bl;
    }

    private void addObservers(LLNode lLNode) {
        this.activeObservers = LLNode.append(this.activeObservers, lLNode);
    }

    private static class LLNode {
        private final Observer observer;
        private LLNode next;

        public LLNode(Observer observer) {
            this.observer = observer;
        }

        public static int length(LLNode lLNode) {
            int n = 0;
            while (lLNode != null) {
                ++n;
                lLNode = lLNode.next;
            }
            return n;
        }

        public static LLNode append(LLNode lLNode, LLNode lLNode2) {
            if (lLNode == null) {
                return lLNode2;
            }
            LLNode lLNode3 = lLNode;
            while (lLNode3.next != null) {
                lLNode3 = lLNode3.next;
            }
            lLNode3.next = lLNode2;
            return lLNode;
        }
    }
}

