/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.utils;

import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import weblogic.xml.babel.stream.DOMOutputStream;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.SOAPElementWriter;
import weblogic.xml.security.utils.XMLOutputStreamWriter;
import weblogic.xml.security.utils.XMLWriter;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.XMLOutputStream;

public class XMLWriterFactory {
    private static final XMLWriterFactory theOne = new XMLWriterFactory();
    private static final Map DEFAULT_PREFIXES = new HashMap();

    public static XMLWriterFactory getInstance() {
        return theOne;
    }

    public XMLWriter createXMLWriter(XMLOutputStream xMLOutputStream) {
        XMLOutputStreamWriter xMLOutputStreamWriter = xMLOutputStream instanceof NSOutputStream ? new XMLOutputStreamWriter((NSOutputStream)xMLOutputStream) : new XMLOutputStreamWriter(xMLOutputStream);
        xMLOutputStreamWriter.setDefaultPrefixes(DEFAULT_PREFIXES);
        return xMLOutputStreamWriter;
    }

    public XMLWriter createXMLWriter(SOAPElement sOAPElement) {
        SOAPElementWriter sOAPElementWriter = new SOAPElementWriter(sOAPElement);
        sOAPElementWriter.setDefaultPrefixes(DEFAULT_PREFIXES);
        return sOAPElementWriter;
    }

    public XMLWriter createXMLWriter(Document document) {
        return this.createXMLWriter((XMLOutputStream)new DOMOutputStream(document));
    }

    static {
        DEFAULT_PREFIXES.put(WSUConstants.WSU_URI, "wsu");
        DEFAULT_PREFIXES.put(WSSEConstants.WSSE_URI, "wsse");
        DEFAULT_PREFIXES.put("http://www.w3.org/2001/04/xmlenc#", "xenc");
        DEFAULT_PREFIXES.put("http://www.w3.org/2000/09/xmldsig#", "dsig");
        DEFAULT_PREFIXES.put("http://www.w3.org/2001/10/xml-exc-c14n#", "c14n");
    }
}

