/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.xml.security.SecurityAssertion;
import weblogic.xml.security.UserInfo;
import weblogic.xml.security.assertion.ElementConfidentialityAssertion;
import weblogic.xml.security.assertion.ElementIntegrityAssertion;
import weblogic.xml.security.assertion.IdentityAssertion;
import weblogic.xml.security.assertion.IntegrityAssertion;
import weblogic.xml.security.keyinfo.KeyResolver;
import weblogic.xml.security.keyinfo.KeyResult;
import weblogic.xml.security.keyinfo.KeypairProvider;
import weblogic.xml.security.keyinfo.X509KeyResult;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.utils.ObservedXMLInputStream;
import weblogic.xml.security.utils.XMLInputStreamBase;
import weblogic.xml.security.wsse.SecureInputStream;
import weblogic.xml.security.wsse.Security;
import weblogic.xml.security.wsse.UsernameToken;
import weblogic.xml.security.wsse.internal.MappingObserver;
import weblogic.xml.security.wsse.internal.Utils;
import weblogic.xml.security.wsse.v200207.SecureInputStreamInternal;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.BufferedXMLInputStream;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public class SecureSoapInputStream
extends XMLInputStreamBase {
    private final MappingObserver beforeMapper;
    private final MappingObserver afterMapper;
    private final SecureInputStream delegate;
    private final String role;
    private SecurityAssertion[] assertions;
    private boolean processingComplete = false;

    public SecureSoapInputStream(XMLInputStream xMLInputStream, String string, PrivateKey privateKey) throws XMLStreamException {
        this(xMLInputStream, string, new KeyResolver());
        if (privateKey != null) {
            this.delegate.getKeyResolver().addKeyProvider(new KeypairProvider(null, privateKey, null, null, null));
        }
    }

    public SecureSoapInputStream(XMLInputStream xMLInputStream, String string, KeyResolver keyResolver) throws XMLStreamException {
        this.role = string;
        XMLInputStream xMLInputStream2 = xMLInputStream;
        this.beforeMapper = new MappingObserver();
        xMLInputStream2 = new ObservedXMLInputStream(xMLInputStream, this.beforeMapper);
        this.delegate = new SecureInputStreamInternal(xMLInputStream2, string, keyResolver);
        xMLInputStream2 = this.delegate;
        this.afterMapper = new MappingObserver();
        this.source = xMLInputStream2 = new ObservedXMLInputStream(xMLInputStream2, this.afterMapper);
    }

    public SecurityAssertion[] getSecurityAssertions() throws XMLStreamException {
        Security security;
        if (this.assertions != null) {
            return this.assertions;
        }
        if (!this.processingComplete) {
            this.bufferRemaining();
        }
        if ((security = this.delegate.getSecurityElement()) == null) {
            return new SecurityAssertion[0];
        }
        if (this.afterMapper.duplicateIds()) {
            throw new SOAPFaultException(weblogic.xml.security.utils.Utils.getQName(WSSEConstants.QNAME_FAULT_FAILEDCHECK), "Invalid message: duplicate IDs found", this.role, null);
        }
        ArrayList arrayList = new ArrayList();
        this.addUsernameAssertions(arrayList);
        this.addSignatureAssertions(arrayList);
        this.addEncryptionAssertions(arrayList);
        this.assertions = new SecurityAssertion[arrayList.size()];
        arrayList.toArray(this.assertions);
        return this.assertions;
    }

    public KeyResolver getKeyResolver() {
        return this.delegate.getKeyResolver();
    }

    public void setKeyResolver(KeyResolver keyResolver) {
        this.delegate.setKeyResolver(keyResolver);
    }

    private void addUsernameAssertions(List list) {
        Security security = this.delegate.getSecurityElement();
        Iterator iterator = security.getUsernameTokens();
        while (iterator.hasNext()) {
            UsernameToken usernameToken = (UsernameToken)iterator.next();
            UserInfo userInfo = usernameToken.getUserInfo();
            list.add(new IdentityAssertion(userInfo));
        }
    }

    private void addSignatureAssertions(List list) {
        Security security = this.delegate.getSecurityElement();
        Iterator iterator = security.getSignatures();
        while (iterator.hasNext()) {
            Signature signature = (Signature)iterator.next();
            try {
                Object object;
                Object object2;
                signature.validateReferences();
                String string = signature.getSignatureMethod();
                KeyResult keyResult = signature.getValidatingKey();
                X509Certificate x509Certificate = keyResult instanceof X509KeyResult ? ((X509KeyResult)keyResult).getCertificate() : null;
                HashMap hashMap = new HashMap();
                HashSet<XMLName> hashSet = new HashSet<XMLName>();
                Iterator iterator2 = signature.getReferences();
                while (iterator2.hasNext()) {
                    Reference reference = (Reference)iterator2.next();
                    if (Utils.validReference(reference)) {
                        object2 = reference.getURI();
                        object = ((String)object2).substring(((String)object2).indexOf(35) + 1);
                        list.add(new IntegrityAssertion(string, (String)object, x509Certificate));
                        XMLName xMLName = this.afterMapper.getElementById((String)object);
                        if (xMLName == null) {
                            xMLName = this.beforeMapper.getElementById((String)object);
                        }
                        if (xMLName == null) continue;
                        Utils.addElement(hashMap, xMLName, (String)object);
                        hashSet.add(xMLName);
                        continue;
                    }
                    System.out.println("Ignoring " + reference + " because it contains " + "an unacceptable transform");
                }
                for (XMLName xMLName : hashSet) {
                    object2 = (SortedSet)hashMap.get(xMLName);
                    if (Utils.equivalent((SortedSet)object2, this.afterMapper.getElementIds(xMLName))) {
                        list.add(new ElementIntegrityAssertion(string, x509Certificate, xMLName, null));
                        object = this.afterMapper.getElementBodyIds(xMLName);
                        if (object != null && !object.isEmpty()) {
                            list.add(new ElementIntegrityAssertion(string, x509Certificate, xMLName, "body"));
                        }
                        if ((object = this.afterMapper.getElementHeaderIds(xMLName)) == null || object.isEmpty()) continue;
                        list.add(new ElementIntegrityAssertion(string, x509Certificate, xMLName, "header"));
                        continue;
                    }
                    if (Utils.isSuperset((SortedSet)object2, this.afterMapper.getElementHeaderIds(xMLName))) {
                        list.add(new ElementIntegrityAssertion(string, x509Certificate, xMLName, "header"));
                    }
                    if (!Utils.isSuperset((SortedSet)object2, this.afterMapper.getElementBodyIds(xMLName))) continue;
                    list.add(new ElementIntegrityAssertion(string, x509Certificate, xMLName, "body"));
                }
            }
            catch (XMLSignatureException xMLSignatureException) {
                Utils.handleException((Throwable)((Object)xMLSignatureException), this.role);
            }
        }
    }

    private void addEncryptionAssertions(List list) {
        Set set = this.beforeMapper.getHeaderElements().keySet();
        Set set2 = this.afterMapper.getHeaderElements().keySet();
        this.createEncryptionAssertions(Utils.diffTypes(set, set2), "header", list);
        set = this.beforeMapper.getBodyElements().keySet();
        set2 = this.afterMapper.getBodyElements().keySet();
        this.createEncryptionAssertions(Utils.diffTypes(set, set2), "body", list);
        set = this.beforeMapper.getElements().keySet();
        set2 = this.afterMapper.getElements().keySet();
        this.createEncryptionAssertions(Utils.diffTypes(set, set2), null, list);
    }

    private void createEncryptionAssertions(Set set, String string, List list) {
        for (XMLName xMLName : set) {
            list.add(new ElementConfidentialityAssertion(xMLName.getLocalName(), xMLName.getNamespaceUri(), string));
        }
    }

    private void bufferRemaining() throws XMLStreamException {
        if (this.hasNext() && !this.processingComplete) {
            BufferedXMLInputStream bufferedXMLInputStream;
            if (!(this.source instanceof BufferedXMLInputStream)) {
                bufferedXMLInputStream = factory.newBufferedInputStream(this.source);
                this.source = bufferedXMLInputStream;
            } else {
                bufferedXMLInputStream = (BufferedXMLInputStream)this.source;
            }
            bufferedXMLInputStream.mark();
            while (this.hasNext()) {
                this.next();
            }
            bufferedXMLInputStream.reset();
            this.processingComplete = true;
        }
    }

    public Set getBodyElementNames() throws XMLStreamException {
        if (!this.processingComplete) {
            this.bufferRemaining();
        }
        return this.afterMapper.getBodyElements().keySet();
    }

    public Set getHeaderElementNames() throws XMLStreamException {
        if (!this.processingComplete) {
            this.bufferRemaining();
        }
        return this.afterMapper.getHeaderElements().keySet();
    }

    public Set getAllElementNames() throws XMLStreamException {
        if (!this.processingComplete) {
            this.bufferRemaining();
        }
        return this.afterMapper.getElements().keySet();
    }

    public Security getSecurityElement() {
        Security security = this.delegate.getSecurityElement();
        return security;
    }

    public Throwable getCreationException() {
        return null;
    }

    public XMLEvent next() throws XMLStreamException {
        return this.source.next();
    }
}

