/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse;

import weblogic.xml.schema.binding.util.StdNamespace;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.utils.XMLOutputStreamBase;
import weblogic.xml.security.wsse.Security;
import weblogic.xml.security.wsse.v200207.SecureOutputPipelineFactory;
import weblogic.xml.security.wsse.v200207.SecurityImpl;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SecureSoapOutputStream
extends XMLOutputStreamBase
implements WSSEConstants,
XMLOutputStream {
    public SecureSoapOutputStream(Security security, XMLOutputStream xMLOutputStream) throws XMLStreamException, SecurityProcessingException {
        this(security, xMLOutputStream, "UTF-8");
    }

    public SecureSoapOutputStream(Security security, XMLOutputStream xMLOutputStream, String string) throws SecurityProcessingException {
        this(security, xMLOutputStream, string, StdNamespace.instance().soapEnvelope());
    }

    public SecureSoapOutputStream(Security security, XMLOutputStream xMLOutputStream, String string, String string2) throws SecurityProcessingException {
        super(null);
        XMLOutputStream xMLOutputStream2 = SecureOutputPipelineFactory.createStream((SecurityImpl)security, xMLOutputStream, string, string2);
        this.setDestination(xMLOutputStream2);
        this.addPrefix(WSSE_URI, "wsse");
    }

    public static void setSoapEnvPrefix(String string) {
        throw new UnsupportedOperationException("Set the namespace for SOAP Envelope on the constructor; prefix will be auto-detected");
    }

    protected void addXMLEvent(XMLEvent xMLEvent) throws XMLStreamException {
        this.dest.add(xMLEvent);
    }
}

