/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Iterator;
import weblogic.xml.security.NamedKey;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.UserInfo;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.ReferenceList;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.specs.EncryptionSpec;
import weblogic.xml.security.specs.SignatureSpec;
import weblogic.xml.security.wsse.BinarySecurityToken;
import weblogic.xml.security.wsse.Token;
import weblogic.xml.security.wsse.UsernameToken;
import weblogic.xml.security.wsu.Timestamp;

public interface Security {
    public static final String WSSE_VERBOSE_PROP = "weblogic.webservice.security.verbose";
    public static final boolean WSSE_VERBOSE = Boolean.getBoolean("weblogic.webservice.security.verbose");

    public Signature addSignature(Token var1) throws SecurityProcessingException;

    public Signature addSignature(Token var1, SignatureSpec var2) throws SecurityProcessingException;

    public EncryptedKey addEncryption(Token var1, EncryptionSpec var2) throws SecurityProcessingException;

    public EncryptedKey addEncryption(X509Certificate var1, EncryptionSpec var2) throws SecurityProcessingException;

    public EncryptedKey addEncryption(Token var1) throws SecurityProcessingException;

    public EncryptedKey addEncryption(Token var1, NamedKey var2, EncryptionSpec var3) throws SecurityProcessingException;

    public ReferenceList addEncryption(NamedKey var1, EncryptionSpec var2) throws SecurityProcessingException;

    public void addBinarySecurityToken(BinarySecurityToken var1);

    public void addUsernameToken(UsernameToken var1);

    public Token addToken(Token var1);

    public Token addToken(X509Certificate var1, PrivateKey var2);

    public Token addToken(UserInfo var1);

    public Iterator getUsernameTokens();

    public Iterator getBinarySecurityTokens();

    public Token getTokenById(String var1);

    public Iterator getSignatures();

    public Iterator getEncryptedKeys();

    public String getRole();

    public Iterator getChildren();

    public Iterator getTimestamps();

    public Timestamp addTimestamp();

    public Timestamp addTimestamp(long var1);

    public Timestamp addTimestamp(Calendar var1);

    public Timestamp addTimestamp(Calendar var1, Calendar var2);

    public boolean expired();

    public boolean expired(long var1);
}

