/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse;

import weblogic.xml.security.utils.XMLObjectReader;
import weblogic.xml.security.wsse.v200207.BinarySecurityTokenImpl;
import weblogic.xml.security.wsse.v200207.SecurityImpl;
import weblogic.xml.security.wsse.v200207.SecurityTokenReferenceImpl;
import weblogic.xml.security.wsse.v200207.UsernameTokenImpl;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class WSSEReader
extends XMLObjectReader
implements WSSEConstants {
    private static final WSSEReader singleton = new WSSEReader();

    private WSSEReader() {
        this.register(WSSE_URI, "BinarySecurityToken", 0);
        this.register(WSSE_URI, "UsernameToken", 7);
        this.register(WSSE_URI, "Security", 4);
        this.register(WSSE_URI, "SecurityTokenReference", 5);
    }

    public Object readObjectInternal(int n, String string, XMLInputStream xMLInputStream) throws XMLStreamException {
        switch (n) {
            case 0: {
                return new BinarySecurityTokenImpl(xMLInputStream, string);
            }
            case 7: {
                return new UsernameTokenImpl(xMLInputStream, string);
            }
            case 4: {
                return new SecurityImpl(xMLInputStream, string);
            }
            case 5: {
                return new SecurityTokenReferenceImpl(xMLInputStream, string);
            }
        }
        throw new AssertionError((Object)("Unknown typecode: " + n));
    }

    public static Object read(XMLInputStream xMLInputStream) throws XMLStreamException {
        return singleton.readObject(xMLInputStream);
    }

    public static Object read(XMLInputStream xMLInputStream, int n) throws XMLStreamException {
        return singleton.readObject(xMLInputStream, n);
    }
}

