/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.internal;

import java.security.Key;
import weblogic.xml.security.NamedKey;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.encryption.DataReference;
import weblogic.xml.security.encryption.EncryptXMLOutputStream;
import weblogic.xml.security.encryption.EncryptedData;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.encryption.ReferenceList;
import weblogic.xml.security.keyinfo.KeyInfo;
import weblogic.xml.security.utils.Preprocessor;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class EncryptingPreprocessor
implements Preprocessor {
    private final EncryptXMLOutputStream enXos;
    private final EncryptionMethod encryptionMethod;
    private final String keyName;
    private final ReferenceList refs;
    private int encryptionDepth = 0;
    private final Key key;

    public EncryptingPreprocessor(EncryptedKey encryptedKey, String string, EncryptXMLOutputStream encryptXMLOutputStream) throws EncryptionException {
        ReferenceList referenceList = encryptedKey.getReferenceList();
        if (referenceList == null) {
            referenceList = new ReferenceList();
            encryptedKey.setReferenceList(referenceList);
        }
        this.enXos = encryptXMLOutputStream;
        this.encryptionMethod = EncryptionMethod.get(string);
        this.key = encryptedKey.getWrappedKey(this.encryptionMethod);
        this.keyName = encryptedKey.getCarriedKeyName();
        this.refs = referenceList;
    }

    public EncryptingPreprocessor(NamedKey namedKey, String string, EncryptXMLOutputStream encryptXMLOutputStream) throws EncryptionException {
        this.enXos = encryptXMLOutputStream;
        this.encryptionMethod = EncryptionMethod.get(string);
        this.key = namedKey.getKey();
        this.refs = namedKey.getReferenceList();
        this.keyName = namedKey.getName();
    }

    public void begin(StartElement startElement, XMLOutputStream xMLOutputStream) throws XMLStreamException {
        if (this.encryptionDepth != 0) {
            ++this.encryptionDepth;
            xMLOutputStream.add((XMLEvent)startElement);
            return;
        }
        String string = Utils.generateId("EncryptedData");
        EncryptedData encryptedData = new EncryptedData();
        encryptedData.setEncryptionMethod(this.encryptionMethod);
        encryptedData.setId(string);
        encryptedData.setKey(this.key);
        if (this.keyName != null) {
            encryptedData.setKeyInfo(new KeyInfo(this.keyName));
        }
        try {
            if ("Body".equals(startElement.getName().getLocalName())) {
                xMLOutputStream.add((XMLEvent)startElement);
                this.enXos.beginEncrypt(encryptedData);
            } else {
                this.enXos.beginEncrypt(encryptedData);
                xMLOutputStream.add((XMLEvent)startElement);
            }
        }
        catch (ClassCastException classCastException) {
            throw new SecurityProcessingException("Attempted encryption operation on a non-encrypting stream", classCastException);
        }
        this.refs.addReference(new DataReference(string));
        ++this.encryptionDepth;
    }

    public void end(EndElement endElement, XMLOutputStream xMLOutputStream) throws XMLStreamException {
        --this.encryptionDepth;
        switch (this.encryptionDepth) {
            case -1: {
                throw new XMLStreamException("Unbalanced start/end tags on encrypted element");
            }
            case 0: {
                if ("Body".equals(endElement.getName().getLocalName())) {
                    xMLOutputStream.flush();
                    try {
                        this.enXos.endEncrypt();
                    }
                    catch (ClassCastException classCastException) {
                        throw new SecurityProcessingException("Attempted encryption operation on a non-encrypting stream", classCastException);
                    }
                    xMLOutputStream.add((XMLEvent)endElement);
                    break;
                }
                xMLOutputStream.add((XMLEvent)endElement);
                xMLOutputStream.flush();
                try {
                    this.enXos.endEncrypt();
                    break;
                }
                catch (ClassCastException classCastException) {
                    throw new SecurityProcessingException("Attempted encryption operation on a non-encrypting stream", classCastException);
                }
            }
        }
    }
}

