/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.internal;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Iterator;
import java.util.Map;
import weblogic.utils.collections.Stack;
import weblogic.xml.schema.binding.util.StdNamespace;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.ReferenceList;
import weblogic.xml.security.keyinfo.KeyInfo;
import weblogic.xml.security.keyinfo.KeyInfoValidationException;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.signature.SoapNamespaceHelper;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.XMLEventBuffer;
import weblogic.xml.security.utils.XMLOutputStreamBase;
import weblogic.xml.security.wsse.BinarySecurityToken;
import weblogic.xml.security.wsse.SecurityTokenReference;
import weblogic.xml.security.wsse.UsernameToken;
import weblogic.xml.security.wsse.v200207.UsernameTokenImpl;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.security.wsu.Timestamp;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class InsertionOutputStream
extends XMLOutputStreamBase {
    private static final int PRE_INSERT = -1;
    private static final int BUFFERING = 0;
    private static final int POST_INSERT = 1;
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private static final String XSD_TRUE = "1";
    private final Object[] children;
    private final String soapNS;
    private String role;
    private Stack stack;
    private int state;
    private XMLEventBuffer buffer;
    private boolean debug = false;

    public InsertionOutputStream(String string, String string2, Object[] objectArray, XMLOutputStream xMLOutputStream) {
        super(xMLOutputStream);
        if (string2 == null) {
            throw new IllegalArgumentException("Cannot set soapNS to null");
        }
        this.state = -1;
        this.soapNS = string2;
        this.role = string;
        this.children = objectArray;
        this.stack = new Stack();
        this.buffer = null;
    }

    public void close(boolean bl) throws XMLStreamException {
        switch (this.state) {
            case -1: {
                throw new AssertionError((Object)"never found place to insert security");
            }
            case 0: {
                this.insertXML();
                while (this.buffer.hasNext()) {
                    this.dest.add(this.buffer.next());
                }
                this.buffer = null;
                this.state = 1;
                break;
            }
        }
        super.close(bl);
    }

    public void flush() {
    }

    protected void addXMLEvent(XMLEvent xMLEvent) throws XMLStreamException {
        if (this.debug) {
            System.out.println("ios - got " + xMLEvent);
        }
        block0 : switch (this.state) {
            case 0: 
            case 1: {
                this.write(xMLEvent);
                break;
            }
            case -1: {
                switch (xMLEvent.getType()) {
                    case 2: {
                        StartElement startElement = (StartElement)xMLEvent;
                        if (this.inHeader(this.stack)) {
                            if (this.matchingSecurity(startElement, this.role)) {
                                this.write((XMLEvent)startElement);
                                this.insertChildren();
                                break block0;
                            }
                            this.stack.push((Object)startElement);
                            this.write((XMLEvent)startElement);
                            break block0;
                        }
                        if (this.startBody(startElement)) {
                            this.insertHeader();
                            this.write((XMLEvent)startElement);
                            break block0;
                        }
                        this.stack.push((Object)startElement);
                        this.write((XMLEvent)startElement);
                        break block0;
                    }
                    case 4: {
                        EndElement endElement = (EndElement)xMLEvent;
                        if (this.inHeader(this.stack) && this.endHeader(endElement)) {
                            this.insertElement(this.getSoapPrefix(this.stack));
                            this.write((XMLEvent)endElement);
                            break block0;
                        }
                        this.stack.pop();
                        this.write((XMLEvent)endElement);
                        break block0;
                    }
                }
                this.write(xMLEvent);
            }
        }
    }

    private String getSoapPrefix(Stack stack) {
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            XMLName xMLName = ((StartElement)iterator.next()).getName();
            String string = xMLName.getNamespaceUri();
            if (!this.soapNS.equals(string)) continue;
            return xMLName.getPrefix();
        }
        throw new AssertionError((Object)"Unable to discover SOAP Prefix from message");
    }

    private void write(XMLEvent xMLEvent) throws XMLStreamException {
        if (this.state == 0) {
            this.buffer.add(xMLEvent);
        } else {
            this.dest.add(xMLEvent);
        }
    }

    private void insertHeader() throws XMLStreamException {
        String string = this.getSoapPrefix(this.stack);
        XMLName xMLName = ElementFactory.createXMLName(this.soapNS, SOAP_HEADER, string);
        this.dest.add((XMLEvent)ElementFactory.createStartElement(xMLName));
        this.insertElement(string);
        this.buffer.add((XMLEvent)ElementFactory.createEndElement(xMLName));
    }

    private void insertElement(String string) throws XMLStreamException {
        this.dest.add((XMLEvent)ElementFactory.createStartElement(ElementFactory.createXMLName(WSSEConstants.WSSE_URI, "Security")));
        XMLName xMLName = ElementFactory.createXMLName(null, "mustUnderstand", string);
        this.dest.add(ElementFactory.createAttribute(xMLName, XSD_TRUE));
        if (this.role != null) {
            XMLName xMLName2 = ElementFactory.createXMLName(null, "role", string);
            this.dest.add(ElementFactory.createAttribute(xMLName2, this.role));
        }
        this.insertChildren();
        this.buffer.add((XMLEvent)ElementFactory.createEndElement(WSSEConstants.WSSE_URI, "Security"));
    }

    private void insertChildren() {
        this.buffer = new XMLEventBuffer();
        this.state = 0;
    }

    private void insertXML() throws XMLStreamException {
        for (int i = 0; i < this.children.length; ++i) {
            Object object;
            Object object2 = this.children[i];
            if (object2 instanceof BinarySecurityToken) {
                ((BinarySecurityToken)object2).toXML(this.dest);
                continue;
            }
            if (object2 instanceof UsernameToken) {
                ((UsernameToken)object2).toXML(this.dest);
                continue;
            }
            if (object2 instanceof Signature) {
                object = (Signature)object2;
                if (this.emptySignature((Signature)object)) continue;
                this.finish((Signature)object, this.dest.getNamespaces());
                ((Signature)object2).toXML(this.dest, "http://www.w3.org/2000/09/xmldsig#", 0);
                continue;
            }
            if (object2 instanceof EncryptedKey) {
                object = (EncryptedKey)object2;
                if (this.unusedKey((EncryptedKey)object)) continue;
                this.finish((EncryptedKey)object);
                ((EncryptedKey)object).toXML(this.dest, "http://www.w3.org/2001/04/xmlenc#", 0);
                continue;
            }
            if (object2 instanceof ReferenceList) {
                ((ReferenceList)object2).toXML(this.dest, "http://www.w3.org/2001/04/xmlenc#", 0);
                continue;
            }
            if (object2 instanceof Timestamp) {
                object = (Timestamp)object2;
                object.toXML(this.dest);
                continue;
            }
            throw new AssertionError((Object)("unsupported child type for Security: " + object2));
        }
        this.state = 1;
    }

    private boolean startBody(StartElement startElement) {
        XMLName xMLName = startElement.getName();
        String string = xMLName.getLocalName();
        if (!SOAP_BODY.equals(string)) {
            return false;
        }
        String string2 = xMLName.getNamespaceUri();
        return string2 == null || string2.equals(this.soapNS);
    }

    private boolean matchingSecurity(StartElement startElement, String string) {
        XMLName xMLName = startElement.getName();
        String string2 = xMLName.getNamespaceUri();
        String string3 = xMLName.getLocalName();
        if (!WSSEConstants.WSSE_URI.equals(string2)) {
            return false;
        }
        if (!"Security".equals(string3)) {
            return false;
        }
        String string4 = StreamUtils.getAttribute(startElement, "role");
        return !(string4 == null ? string != null : !string4.equals(string));
    }

    private boolean endHeader(EndElement endElement) {
        XMLName xMLName = endElement.getName();
        return this.isSOAPHeader(xMLName);
    }

    private boolean inHeader(Stack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        StartElement startElement = (StartElement)stack.peek();
        XMLName xMLName = startElement.getName();
        return this.isSOAPHeader(xMLName);
    }

    private boolean isSOAPHeader(XMLName xMLName) {
        String string = xMLName.getNamespaceUri();
        if (string == null || !string.equals(this.soapNS)) {
            return false;
        }
        String string2 = xMLName.getLocalName();
        return SOAP_HEADER.equals(string2);
    }

    private boolean unusedKey(EncryptedKey encryptedKey) {
        ReferenceList referenceList = encryptedKey.getReferenceList();
        return referenceList != null && !referenceList.getReferences().hasNext();
    }

    private boolean emptySignature(Signature signature) {
        return !signature.getReferences().hasNext();
    }

    private void finish(Signature signature, Map map) throws SecurityProcessingException {
        SecurityTokenReference securityTokenReference;
        KeyInfo keyInfo;
        SoapNamespaceHelper.setNamespace(signature, map);
        try {
            keyInfo = signature.getKeyInfo();
        }
        catch (KeyInfoValidationException keyInfoValidationException) {
            throw new SecurityProcessingException("Validation error retrieving key info for signature", keyInfoValidationException);
        }
        Key key = null;
        Iterator iterator = keyInfo.getSecurityTokenReferences();
        while (iterator.hasNext() && (key = (securityTokenReference = (SecurityTokenReference)iterator.next()).getPrivateKey()) == null && (key = securityTokenReference.getSecretKey()) == null) {
        }
        if (key == null) {
            throw new SecurityProcessingException("unable to retrieve private key for signing");
        }
        try {
            signature.sign(key);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new SecurityProcessingException("Unable to complete signature " + signature, (Throwable)((Object)xMLSignatureException));
        }
    }

    private void finish(EncryptedKey encryptedKey) {
    }

    public static void main(String[] stringArray) throws FileNotFoundException, XMLStreamException {
        XMLInputStream xMLInputStream = null;
        XMLOutputStream xMLOutputStream = null;
        if (stringArray.length < 1) {
            System.out.println("InsertionOutputStream <input> [<output>]");
            return;
        }
        Object[] objectArray = new FileInputStream(stringArray[0]);
        xMLInputStream = XMLInputStreamFactory.newInstance().newInputStream((InputStream)objectArray);
        xMLOutputStream = stringArray.length == 3 ? XMLOutputStreamFactory.newInstance().newOutputStream((OutputStream)new FileOutputStream(stringArray[1])) : XMLOutputStreamFactory.newInstance().newOutputStream((OutputStream)System.out);
        objectArray = new Object[]{new UsernameTokenImpl("username", "password")};
        String string = StdNamespace.instance().soapEnvelope();
        xMLOutputStream = new InsertionOutputStream(null, string, objectArray, xMLOutputStream);
        xMLOutputStream = new InsertionOutputStream(null, string, objectArray, xMLOutputStream);
        xMLOutputStream.add(xMLInputStream);
        xMLOutputStream.close(true);
    }
}

